/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer.northbound;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.MethodNotAllowedException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnsupportedMediaTypeException;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.samples.loadbalancer.IConfigManager;
import org.opendaylight.controller.samples.loadbalancer.entities.Pool;
import org.opendaylight.controller.samples.loadbalancer.entities.PoolMember;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;
import org.opendaylight.controller.samples.loadbalancer.northbound.Pools;
import org.opendaylight.controller.samples.loadbalancer.northbound.VIPs;

@Path(value="/")
public class LoadBalancerNorthbound {
    private IConfigManager getConfigManagerService(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        boolean found = false;
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            found = true;
        }
        if (!found) {
            throw new ResourceNotFoundException(containerName + " " + RestMessages.NOCONTAINER.toString());
        }
        IConfigManager configManager = (IConfigManager)ServiceHelper.getInstance(IConfigManager.class, (String)containerName, (Object)this);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer" + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return configManager;
    }

    @Path(value="/{containerName}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Pools.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable")})
    public Pools getAllPools(@PathParam(value="containerName") String containerName) {
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return new Pools(configManager.getAllPools());
    }

    @Path(value="/{containerName}/vips")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=VIPs.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable")})
    public VIPs getAllVIPs(@PathParam(value="containerName") String containerName) {
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return new VIPs(configManager.getAllVIPs());
    }

    @Path(value="/{containerName}/create/vip")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="VIP created successfully"), @ResponseCode(code=404, condition="The Container Name not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable"), @ResponseCode(code=409, condition="VIP already exist"), @ResponseCode(code=415, condition="Invalid input data")})
    public Response addVIP(@PathParam(value="containerName") String containerName, @TypeHint(value=VIP.class) VIP inVIP) {
        VIP vipInput = inVIP;
        String name = vipInput.getName();
        String ip = vipInput.getIp();
        String protocol = vipInput.getProtocol();
        short protocolPort = vipInput.getPort();
        String poolName = vipInput.getPoolName();
        if (name.isEmpty() || ip.isEmpty() || protocol.isEmpty() || protocolPort < 0) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.vipExists(name, ip, protocol, protocolPort, poolName)) {
            VIP vip = configManager.createVIP(name, ip, protocol, protocolPort, poolName);
            if (vip != null) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        } else {
            throw new ResourceConflictException(" VIP already exists");
        }
        throw new InternalServerErrorException(" Creation of VIP failed");
    }

    @Path(value="/{containerName}/update/vip")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="VIP updated successfully"), @ResponseCode(code=404, condition="The containerName not found"), @ResponseCode(code=503, condition="VIP not found"), @ResponseCode(code=404, condition="Pool not found"), @ResponseCode(code=405, condition="Pool already attached to the VIP"), @ResponseCode(code=415, condition="Invalid input name")})
    public Response updateVIP(@PathParam(value="containerName") String containerName, @TypeHint(value=VIP.class) VIP inVIP) {
        VIP vipInput = inVIP;
        String name = vipInput.getName();
        String poolName = vipInput.getPoolName();
        if (name.isEmpty() || poolName.isEmpty()) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.poolExists(poolName)) {
            throw new ResourceNotFoundException(" Pool not found");
        }
        if (configManager.getVIPAttachedPool(name) != null) {
            throw new MethodNotAllowedException("Pool already attached to a VIP");
        }
        if (configManager.updateVIP(name, poolName) != null) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        throw new InternalServerErrorException(" Update of VIP failed");
    }

    @Path(value="/{containerName}/delete/vip/{vipName}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="VIP deleted successfully"), @ResponseCode(code=404, condition="The containerName not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable"), @ResponseCode(code=404, condition="VIP not found"), @ResponseCode(code=500, condition="Failed to delete VIP")})
    public Response deleteVIP(@PathParam(value="containerName") String containerName, @PathParam(value="vipName") String vipName) {
        if (vipName.isEmpty()) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer" + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.vipExists(vipName)) {
            throw new ResourceNotFoundException(" VIP not found");
        }
        for (VIP vip : configManager.getAllVIPs()) {
            if (!vip.getName().equals(vipName)) continue;
            configManager.deleteVIP(vipName);
            return Response.ok().build();
        }
        throw new InternalServerErrorException(" Deletion of VIP failed");
    }

    @Path(value="/{containerName}/create/pool")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Pool created successfully"), @ResponseCode(code=404, condition="The containerName not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable"), @ResponseCode(code=409, condition="Pool already exist"), @ResponseCode(code=415, condition="Invalid input data")})
    public Response addPool(@PathParam(value="containerName") String containerName, @TypeHint(value=Pool.class) Pool inPool) {
        Pool poolInput = inPool;
        String name = poolInput.getName();
        String lbMethod = poolInput.getLbMethod();
        if (name.isEmpty() || lbMethod.isEmpty()) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.poolExists(name)) {
            Pool pool = configManager.createPool(name, lbMethod);
            if (pool != null) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        } else {
            throw new ResourceConflictException(" Pool already exists");
        }
        throw new InternalServerErrorException(" Creation of pool failed");
    }

    @Path(value="/{containerName}/delete/pool/{poolName}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Pool deleted successfully"), @ResponseCode(code=404, condition="The containerName not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable"), @ResponseCode(code=404, condition="Pool not found"), @ResponseCode(code=500, condition="Failed to delete Pool")})
    public Response deletePool(@PathParam(value="containerName") String containerName, @PathParam(value="poolName") String poolName) {
        if (poolName.isEmpty()) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer" + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.poolExists(poolName)) {
            throw new ResourceNotFoundException(" Pool not found");
        }
        for (Pool pool : configManager.getAllPools()) {
            if (!pool.getName().equals(poolName)) continue;
            configManager.deletePool(poolName);
            return Response.ok().build();
        }
        throw new InternalServerErrorException(" Deletion of pool failed");
    }

    @Path(value="/{containerName}/create/poolmember")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Pool member created successfully"), @ResponseCode(code=404, condition="The containerName not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable"), @ResponseCode(code=404, condition="Pool not found"), @ResponseCode(code=409, condition="Pool member already exist"), @ResponseCode(code=415, condition="Invalid input data")})
    public Response addPoolMember(@PathParam(value="containerName") String containerName, @TypeHint(value=PoolMember.class) PoolMember inPoolMember) {
        PoolMember pmInput = inPoolMember;
        String name = pmInput.getName();
        String memberIP = pmInput.getIp();
        String poolName = pmInput.getPoolName();
        if (name.isEmpty() || memberIP.isEmpty() || poolName.isEmpty()) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.poolExists(poolName)) {
            throw new ResourceNotFoundException(" Pool not found");
        }
        if (!configManager.memberExists(name, memberIP, poolName)) {
            PoolMember poolMember = configManager.addPoolMember(name, memberIP, poolName);
            if (poolMember != null) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        } else {
            throw new ResourceConflictException(" Pool member already exists");
        }
        throw new InternalServerErrorException(" Creation of pool member failed");
    }

    @Path(value="/{containerName}/delete/poolmember/{poolMemberName}/{poolName}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Pool member deleted successfully"), @ResponseCode(code=404, condition="The containerName not found"), @ResponseCode(code=503, condition="Load balancer service is unavailable"), @ResponseCode(code=404, condition="Pool member not found"), @ResponseCode(code=404, condition="Pool not found")})
    public Response deletePoolMember(@PathParam(value="containerName") String containerName, @PathParam(value="poolMemberName") String poolMemberName, @PathParam(value="poolName") String poolName) {
        if (poolMemberName.isEmpty() || poolName.isEmpty()) {
            throw new UnsupportedMediaTypeException(RestMessages.INVALIDDATA.toString());
        }
        IConfigManager configManager = this.getConfigManagerService(containerName);
        if (configManager == null) {
            throw new ServiceUnavailableException("Load Balancer" + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!configManager.poolExists(poolName)) {
            throw new ResourceNotFoundException(" Pool not found");
        }
        if (configManager.memberExists(poolMemberName, poolName)) {
            configManager.removePoolMember(poolMemberName, poolName);
            return Response.ok().build();
        }
        throw new ResourceNotFoundException(" Pool member not found");
    }
}

