/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.bridgedomain.northbound;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.northbound.commons.exception.NotAcceptableException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.ConfigConstants;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.IBridgeDomainConfigService;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;

@Path(value="/")
public class BridgeDomainNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private IBridgeDomainConfigService getConfigurationService() {
        return (IBridgeDomainConfigService)ServiceHelper.getGlobalInstance(IBridgeDomainConfigService.class, (Object)this);
    }

    private IConnectionManager getConnectionManager() {
        return (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
    }

    @Path(value="/bridge/{nodeType}/{nodeId}/{bridgeName}")
    @POST
    @StatusCodes(value={@ResponseCode(code=201, condition="Bridge created successfully"), @ResponseCode(code=404, condition="Could not create Bridge"), @ResponseCode(code=412, condition="Failed to create Bridge due to an exception"), @ResponseCode(code=503, condition="Bridge Domain Configuration Service not available")})
    public Response createBridge(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="bridgeName") String name, Map<String, Object> bridgeConfigs) {
        IBridgeDomainConfigService configurationService = this.getConfigurationService();
        if (configurationService == null) {
            throw new ServiceUnavailableException("IBridgeDomainConfigService not available.");
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Status status = null;
        try {
            Map<ConfigConstants, Object> configs = this.buildConfig(bridgeConfigs);
            status = configurationService.createBridgeDomain(node, name, configs);
            if (status.getCode().equals((Object)StatusCode.SUCCESS)) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        }
        catch (Throwable t) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        throw new ResourceNotFoundException(status.getDescription());
    }

    @Path(value="/bridge/{nodeType}/{nodeId}/{bridgeName}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=200, condition="Bridge deleted successfully"), @ResponseCode(code=404, condition="Could not delete Bridge"), @ResponseCode(code=412, condition="Failed to delete Bridge due to an exception"), @ResponseCode(code=503, condition="Bridge Domain Configuration Service not available")})
    public Response deleteBridge(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="bridgeName") String name) {
        IBridgeDomainConfigService configurationService = this.getConfigurationService();
        if (configurationService == null) {
            throw new ServiceUnavailableException("IBridgeDomainConfigService not available.");
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Status status = null;
        try {
            status = configurationService.deleteBridgeDomain(node, name);
            if (status.getCode().equals((Object)StatusCode.SUCCESS)) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        }
        catch (Throwable t) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        throw new ResourceNotFoundException(status.getDescription());
    }

    @Path(value="/port/{nodeType}/{nodeId}/{bridgeName}/{portName}")
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Port added successfully"), @ResponseCode(code=404, condition="Could not add Port to the Bridge"), @ResponseCode(code=412, condition="Failed to add Port due to an exception"), @ResponseCode(code=503, condition="Bridge Domain Configuration Service not available")})
    public Response addPort(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="bridgeName") String bridge, @PathParam(value="portName") String port, Map<String, Object> portConfigs) {
        IBridgeDomainConfigService configurationService = this.getConfigurationService();
        if (configurationService == null) {
            throw new ServiceUnavailableException("IBridgeDomainConfigService not available.");
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Status status = null;
        try {
            Map<ConfigConstants, Object> configs = this.buildConfig(portConfigs);
            status = configurationService.addPort(node, bridge, port, configs);
            if (status.getCode().equals((Object)StatusCode.SUCCESS)) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        }
        catch (Throwable t) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        throw new ResourceNotFoundException(status.getDescription());
    }

    @Path(value="/port/{nodeType}/{nodeId}/{bridgeName}/{portName}")
    @DELETE
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Port deleted successfully"), @ResponseCode(code=404, condition="Could not delete Port to the Bridge"), @ResponseCode(code=412, condition="Failed to delete Port due to an exception"), @ResponseCode(code=503, condition="Bridge Domain Configuration Service not available")})
    public Response deletePort(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="bridgeName") String bridge, @PathParam(value="portName") String port) {
        IBridgeDomainConfigService configurationService = this.getConfigurationService();
        if (configurationService == null) {
            throw new ServiceUnavailableException("IBridgeDomainConfigService not available.");
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Status status = null;
        try {
            status = configurationService.deletePort(node, bridge, port);
            if (status.getCode().equals((Object)StatusCode.SUCCESS)) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        }
        catch (Throwable t) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        throw new ResourceNotFoundException(status.getDescription());
    }

    private Map<ConfigConstants, Object> buildConfig(Map<String, Object> rawConfigs) {
        if (rawConfigs == null) {
            return null;
        }
        HashMap<ConfigConstants, Object> configs = new HashMap<ConfigConstants, Object>();
        for (String key : rawConfigs.keySet()) {
            ConfigConstants cc = ConfigConstants.valueOf((String)key.toUpperCase());
            configs.put(cc, rawConfigs.get(key));
        }
        return configs;
    }

    @Path(value="/port/{nodeType}/{nodeId}/{bridgeName}/{portName}/{vlan}")
    @POST
    @StatusCodes(value={@ResponseCode(code=201, condition="Created Port with Vlan tag successfully"), @ResponseCode(code=404, condition="Could not add Port,Vlan to the Bridge"), @ResponseCode(code=406, condition="Invalid Vlan parameter passed."), @ResponseCode(code=412, condition="Failed to add Port,Vlan due to an exception"), @ResponseCode(code=503, condition="Bridge Domain Configuration Service not available")})
    public Response addPort(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="bridgeName") String bridge, @PathParam(value="portName") String port, @PathParam(value="vlan") String vlan) {
        IBridgeDomainConfigService configurationService = this.getConfigurationService();
        if (configurationService == null) {
            throw new ServiceUnavailableException("IBridgeDomainConfigService not available.");
        }
        try {
            Integer.parseInt(vlan);
        }
        catch (Exception e) {
            throw new NotAcceptableException("Incorrect Vlan :" + vlan);
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        HashMap<ConfigConstants, String> configs = new HashMap<ConfigConstants, String>();
        configs.put(ConfigConstants.TYPE, ConfigConstants.VLAN.name());
        configs.put(ConfigConstants.VLAN, vlan);
        Status status = null;
        try {
            status = configurationService.addPort(node, bridge, port, configs);
            if (status.getCode().equals((Object)StatusCode.SUCCESS)) {
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        throw new ResourceNotFoundException(status.getDescription());
    }
}

