/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNodeKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SupportingNodeBuilder {
    private NodeId _nodeRef;
    private SupportingNodeKey _key;
    private Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>();

    public NodeId getNodeRef() {
        return this._nodeRef;
    }

    public SupportingNodeKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<SupportingNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SupportingNodeBuilder setNodeRef(NodeId value) {
        this._nodeRef = value;
        return this;
    }

    public SupportingNodeBuilder setKey(SupportingNodeKey value) {
        this._key = value;
        return this;
    }

    public SupportingNodeBuilder addAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType, Augmentation<SupportingNode> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SupportingNode build() {
        return new SupportingNodeImpl(this);
    }

    private static final class SupportingNodeImpl
    implements SupportingNode {
        private final NodeId _nodeRef;
        private final SupportingNodeKey _key;
        private Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>();

        public Class<SupportingNode> getImplementedInterface() {
            return SupportingNode.class;
        }

        private SupportingNodeImpl(SupportingNodeBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new SupportingNodeKey(builder.getNodeRef());
                this._nodeRef = builder.getNodeRef();
            } else {
                this._key = builder.getKey();
                this._nodeRef = this._key.getNodeRef();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public NodeId getNodeRef() {
            return this._nodeRef;
        }

        @Override
        public SupportingNodeKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<SupportingNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nodeRef == null ? 0 : this._nodeRef.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SupportingNodeImpl other = (SupportingNodeImpl)obj;
            if (this._nodeRef == null ? other._nodeRef != null : !this._nodeRef.equals((Object)other._nodeRef)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SupportingNode [_nodeRef=");
            builder.append((Object)this._nodeRef);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

