/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.LinkKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LinkBuilder {
    private LinkKey _key;
    private Destination _destination;
    private LinkId _linkId;
    private Source _source;
    private List<SupportingLink> _supportingLink;
    private Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>();

    public LinkBuilder() {
    }

    public LinkBuilder(LinkAttributes arg) {
        this._destination = arg.getDestination();
        this._linkId = arg.getLinkId();
        this._source = arg.getSource();
        this._supportingLink = arg.getSupportingLink();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LinkAttributes) {
            this._destination = ((LinkAttributes)arg).getDestination();
            this._linkId = ((LinkAttributes)arg).getLinkId();
            this._source = ((LinkAttributes)arg).getSource();
            this._supportingLink = ((LinkAttributes)arg).getSupportingLink();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes] \nbut was: " + arg);
        }
    }

    public LinkKey getKey() {
        return this._key;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public Source getSource() {
        return this._source;
    }

    public List<SupportingLink> getSupportingLink() {
        return this._supportingLink;
    }

    public <E extends Augmentation<Link>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LinkBuilder setKey(LinkKey value) {
        this._key = value;
        return this;
    }

    public LinkBuilder setDestination(Destination value) {
        this._destination = value;
        return this;
    }

    public LinkBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public LinkBuilder setSource(Source value) {
        this._source = value;
        return this;
    }

    public LinkBuilder setSupportingLink(List<SupportingLink> value) {
        this._supportingLink = value;
        return this;
    }

    public LinkBuilder addAugmentation(Class<? extends Augmentation<Link>> augmentationType, Augmentation<Link> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Link build() {
        return new LinkImpl(this);
    }

    private static final class LinkImpl
    implements Link {
        private final LinkKey _key;
        private final Destination _destination;
        private final LinkId _linkId;
        private final Source _source;
        private final List<SupportingLink> _supportingLink;
        private Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>();

        public Class<Link> getImplementedInterface() {
            return Link.class;
        }

        private LinkImpl(LinkBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new LinkKey(builder.getLinkId());
                this._linkId = builder.getLinkId();
            } else {
                this._key = builder.getKey();
                this._linkId = this._key.getLinkId();
            }
            this._destination = builder.getDestination();
            this._source = builder.getSource();
            this._supportingLink = builder.getSupportingLink();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public LinkKey getKey() {
            return this._key;
        }

        @Override
        public Destination getDestination() {
            return this._destination;
        }

        @Override
        public LinkId getLinkId() {
            return this._linkId;
        }

        @Override
        public Source getSource() {
            return this._source;
        }

        @Override
        public List<SupportingLink> getSupportingLink() {
            return this._supportingLink;
        }

        public <E extends Augmentation<Link>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._destination == null ? 0 : this._destination.hashCode());
            result = 31 * result + (this._linkId == null ? 0 : this._linkId.hashCode());
            result = 31 * result + (this._source == null ? 0 : this._source.hashCode());
            result = 31 * result + (this._supportingLink == null ? 0 : this._supportingLink.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LinkImpl other = (LinkImpl)obj;
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._destination == null ? other._destination != null : !this._destination.equals(other._destination)) {
                return false;
            }
            if (this._linkId == null ? other._linkId != null : !this._linkId.equals((Object)other._linkId)) {
                return false;
            }
            if (this._source == null ? other._source != null : !this._source.equals(other._source)) {
                return false;
            }
            if (this._supportingLink == null ? other._supportingLink != null : !this._supportingLink.equals(other._supportingLink)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Link [_key=");
            builder.append(this._key);
            builder.append(", _destination=");
            builder.append(this._destination);
            builder.append(", _linkId=");
            builder.append((Object)this._linkId);
            builder.append(", _source=");
            builder.append(this._source);
            builder.append(", _supportingLink=");
            builder.append(this._supportingLink);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

