/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLinkKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SupportingLinkBuilder {
    private LinkId _linkRef;
    private SupportingLinkKey _key;
    private Map<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>> augmentation = new HashMap<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>>();

    public LinkId getLinkRef() {
        return this._linkRef;
    }

    public SupportingLinkKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<SupportingLink>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SupportingLinkBuilder setLinkRef(LinkId value) {
        this._linkRef = value;
        return this;
    }

    public SupportingLinkBuilder setKey(SupportingLinkKey value) {
        this._key = value;
        return this;
    }

    public SupportingLinkBuilder addAugmentation(Class<? extends Augmentation<SupportingLink>> augmentationType, Augmentation<SupportingLink> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SupportingLink build() {
        return new SupportingLinkImpl(this);
    }

    private static final class SupportingLinkImpl
    implements SupportingLink {
        private final LinkId _linkRef;
        private final SupportingLinkKey _key;
        private Map<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>> augmentation = new HashMap<Class<? extends Augmentation<SupportingLink>>, Augmentation<SupportingLink>>();

        public Class<SupportingLink> getImplementedInterface() {
            return SupportingLink.class;
        }

        private SupportingLinkImpl(SupportingLinkBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new SupportingLinkKey(builder.getLinkRef());
                this._linkRef = builder.getLinkRef();
            } else {
                this._key = builder.getKey();
                this._linkRef = this._key.getLinkRef();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public LinkId getLinkRef() {
            return this._linkRef;
        }

        @Override
        public SupportingLinkKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<SupportingLink>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._linkRef == null ? 0 : this._linkRef.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SupportingLinkImpl other = (SupportingLinkImpl)obj;
            if (this._linkRef == null ? other._linkRef != null : !this._linkRef.equals((Object)other._linkRef)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SupportingLink [_linkRef=");
            builder.append((Object)this._linkRef);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

