/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SourceBuilder {
    private NodeId _sourceNode;
    private TpId _sourceTp;
    private Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();

    public NodeId getSourceNode() {
        return this._sourceNode;
    }

    public TpId getSourceTp() {
        return this._sourceTp;
    }

    public <E extends Augmentation<Source>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SourceBuilder setSourceNode(NodeId value) {
        this._sourceNode = value;
        return this;
    }

    public SourceBuilder setSourceTp(TpId value) {
        this._sourceTp = value;
        return this;
    }

    public SourceBuilder addAugmentation(Class<? extends Augmentation<Source>> augmentationType, Augmentation<Source> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    implements Source {
        private final NodeId _sourceNode;
        private final TpId _sourceTp;
        private Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();

        public Class<Source> getImplementedInterface() {
            return Source.class;
        }

        private SourceImpl(SourceBuilder builder) {
            this._sourceNode = builder.getSourceNode();
            this._sourceTp = builder.getSourceTp();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public NodeId getSourceNode() {
            return this._sourceNode;
        }

        @Override
        public TpId getSourceTp() {
            return this._sourceTp;
        }

        public <E extends Augmentation<Source>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._sourceNode == null ? 0 : this._sourceNode.hashCode());
            result = 31 * result + (this._sourceTp == null ? 0 : this._sourceTp.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceImpl other = (SourceImpl)obj;
            if (this._sourceNode == null ? other._sourceNode != null : !this._sourceNode.equals((Object)other._sourceNode)) {
                return false;
            }
            if (this._sourceTp == null ? other._sourceTp != null : !this._sourceTp.equals((Object)other._sourceTp)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Source [_sourceNode=");
            builder.append((Object)this._sourceNode);
            builder.append(", _sourceTp=");
            builder.append((Object)this._sourceTp);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

