/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.TopologyTypes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.UnderlayTopology;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class TopologyBuilder {
    private List<Link> _link;
    private List<Node> _node;
    private TopologyId _topologyId;
    private TopologyTypes _topologyTypes;
    private List<UnderlayTopology> _underlayTopology;
    private TopologyKey _key;
    private Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();

    public List<Link> getLink() {
        return this._link;
    }

    public List<Node> getNode() {
        return this._node;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public TopologyTypes getTopologyTypes() {
        return this._topologyTypes;
    }

    public List<UnderlayTopology> getUnderlayTopology() {
        return this._underlayTopology;
    }

    public TopologyKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Topology>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TopologyBuilder setLink(List<Link> value) {
        this._link = value;
        return this;
    }

    public TopologyBuilder setNode(List<Node> value) {
        this._node = value;
        return this;
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder setTopologyTypes(TopologyTypes value) {
        this._topologyTypes = value;
        return this;
    }

    public TopologyBuilder setUnderlayTopology(List<UnderlayTopology> value) {
        this._underlayTopology = value;
        return this;
    }

    public TopologyBuilder setKey(TopologyKey value) {
        this._key = value;
        return this;
    }

    public TopologyBuilder addAugmentation(Class<? extends Augmentation<Topology>> augmentationType, Augmentation<Topology> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    implements Topology {
        private final List<Link> _link;
        private final List<Node> _node;
        private final TopologyId _topologyId;
        private final TopologyTypes _topologyTypes;
        private final List<UnderlayTopology> _underlayTopology;
        private final TopologyKey _key;
        private Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();

        public Class<Topology> getImplementedInterface() {
            return Topology.class;
        }

        private TopologyImpl(TopologyBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new TopologyKey(builder.getTopologyId());
                this._topologyId = builder.getTopologyId();
            } else {
                this._key = builder.getKey();
                this._topologyId = this._key.getTopologyId();
            }
            this._link = builder.getLink();
            this._node = builder.getNode();
            this._topologyTypes = builder.getTopologyTypes();
            this._underlayTopology = builder.getUnderlayTopology();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Link> getLink() {
            return this._link;
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        @Override
        public TopologyTypes getTopologyTypes() {
            return this._topologyTypes;
        }

        @Override
        public List<UnderlayTopology> getUnderlayTopology() {
            return this._underlayTopology;
        }

        @Override
        public TopologyKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Topology>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._link == null ? 0 : this._link.hashCode());
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this._topologyId == null ? 0 : this._topologyId.hashCode());
            result = 31 * result + (this._topologyTypes == null ? 0 : this._topologyTypes.hashCode());
            result = 31 * result + (this._underlayTopology == null ? 0 : this._underlayTopology.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TopologyImpl other = (TopologyImpl)obj;
            if (this._link == null ? other._link != null : !this._link.equals(other._link)) {
                return false;
            }
            if (this._node == null ? other._node != null : !this._node.equals(other._node)) {
                return false;
            }
            if (this._topologyId == null ? other._topologyId != null : !this._topologyId.equals((Object)other._topologyId)) {
                return false;
            }
            if (this._topologyTypes == null ? other._topologyTypes != null : !this._topologyTypes.equals(other._topologyTypes)) {
                return false;
            }
            if (this._underlayTopology == null ? other._underlayTopology != null : !this._underlayTopology.equals(other._underlayTopology)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Topology [_link=");
            builder.append(this._link);
            builder.append(", _node=");
            builder.append(this._node);
            builder.append(", _topologyId=");
            builder.append((Object)this._topologyId);
            builder.append(", _topologyTypes=");
            builder.append(this._topologyTypes);
            builder.append(", _underlayTopology=");
            builder.append(this._underlayTopology);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

