/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes.Destination;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class DestinationBuilder {
    private NodeId _destNode;
    private TpId _destTp;
    private Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();

    public NodeId getDestNode() {
        return this._destNode;
    }

    public TpId getDestTp() {
        return this._destTp;
    }

    public <E extends Augmentation<Destination>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DestinationBuilder setDestNode(NodeId value) {
        this._destNode = value;
        return this;
    }

    public DestinationBuilder setDestTp(TpId value) {
        this._destTp = value;
        return this;
    }

    public DestinationBuilder addAugmentation(Class<? extends Augmentation<Destination>> augmentationType, Augmentation<Destination> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Destination build() {
        return new DestinationImpl(this);
    }

    private static final class DestinationImpl
    implements Destination {
        private final NodeId _destNode;
        private final TpId _destTp;
        private Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();

        public Class<Destination> getImplementedInterface() {
            return Destination.class;
        }

        private DestinationImpl(DestinationBuilder builder) {
            this._destNode = builder.getDestNode();
            this._destTp = builder.getDestTp();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public NodeId getDestNode() {
            return this._destNode;
        }

        @Override
        public TpId getDestTp() {
            return this._destTp;
        }

        public <E extends Augmentation<Destination>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._destNode == null ? 0 : this._destNode.hashCode());
            result = 31 * result + (this._destTp == null ? 0 : this._destTp.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DestinationImpl other = (DestinationImpl)obj;
            if (this._destNode == null ? other._destNode != null : !this._destNode.equals((Object)other._destNode)) {
                return false;
            }
            if (this._destTp == null ? other._destTp != null : !this._destTp.equals((Object)other._destTp)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Destination [_destNode=");
            builder.append((Object)this._destNode);
            builder.append(", _destTp=");
            builder.append((Object)this._destTp);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

