/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.Topology;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NetworkTopologyBuilder {
    private List<Topology> _topology;
    private Map<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>> augmentation = new HashMap<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>>();

    public List<Topology> getTopology() {
        return this._topology;
    }

    public <E extends Augmentation<NetworkTopology>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NetworkTopologyBuilder setTopology(List<Topology> value) {
        this._topology = value;
        return this;
    }

    public NetworkTopologyBuilder addAugmentation(Class<? extends Augmentation<NetworkTopology>> augmentationType, Augmentation<NetworkTopology> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NetworkTopology build() {
        return new NetworkTopologyImpl(this);
    }

    private static final class NetworkTopologyImpl
    implements NetworkTopology {
        private final List<Topology> _topology;
        private Map<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>> augmentation = new HashMap<Class<? extends Augmentation<NetworkTopology>>, Augmentation<NetworkTopology>>();

        public Class<NetworkTopology> getImplementedInterface() {
            return NetworkTopology.class;
        }

        private NetworkTopologyImpl(NetworkTopologyBuilder builder) {
            this._topology = builder.getTopology();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Topology> getTopology() {
            return this._topology;
        }

        public <E extends Augmentation<NetworkTopology>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._topology == null ? 0 : this._topology.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTopologyImpl other = (NetworkTopologyImpl)obj;
            if (this._topology == null ? other._topology != null : !this._topology.equals(other._topology)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NetworkTopology [_topology=");
            builder.append(this._topology);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

