/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.mapping.api;

import com.google.common.base.Optional;

public class HandlingPriority
implements Comparable<HandlingPriority> {
    public static final HandlingPriority CANNOT_HANDLE = new HandlingPriority();
    public static final HandlingPriority HANDLE_WITH_DEFAULT_PRIORITY = new HandlingPriority(Integer.MIN_VALUE);
    public static final HandlingPriority HANDLE_WITH_MAX_PRIORITY = new HandlingPriority(Integer.MAX_VALUE);
    private Integer priority;

    public static HandlingPriority getHandlingPriority(int priority) {
        return new HandlingPriority(priority);
    }

    private HandlingPriority(int priority) {
        this.priority = priority;
    }

    private HandlingPriority() {
    }

    public Optional<Integer> getPriority() {
        return Optional.of((Object)this.priority).or(Optional.absent());
    }

    @Override
    public int compareTo(HandlingPriority o) {
        if (this == o) {
            return 0;
        }
        if (this == CANNOT_HANDLE) {
            return -1;
        }
        if (o == CANNOT_HANDLE) {
            return 1;
        }
        if (this.priority > o.priority) {
            return 1;
        }
        if (this.priority == o.priority) {
            return 0;
        }
        if (this.priority < o.priority) {
            return -1;
        }
        throw new IllegalStateException("Unexpected state");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandlingPriority)) {
            return false;
        }
        HandlingPriority that = (HandlingPriority)o;
        return !(this.priority != null ? !this.priority.equals(that.priority) : that.priority != null);
    }

    public int hashCode() {
        return this.priority != null ? this.priority.hashCode() : 0;
    }
}

