/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractGeneratedType;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractGeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;

public final class GeneratedTOBuilderImpl
extends AbstractGeneratedTypeBuilder<GeneratedTOBuilder>
implements GeneratedTOBuilder {
    private GeneratedTransferObject extendsType;
    private final List<GeneratedPropertyBuilder> equalsProperties = new ArrayList<GeneratedPropertyBuilder>();
    private final List<GeneratedPropertyBuilder> hashProperties = new ArrayList<GeneratedPropertyBuilder>();
    private final List<GeneratedPropertyBuilder> toStringProperties = new ArrayList<GeneratedPropertyBuilder>();
    private boolean isTypedef = false;
    private boolean isUnionType = false;
    private boolean isUnionTypeBuilder = false;
    private Restrictions restrictions;
    private GeneratedPropertyBuilder SUID;

    public GeneratedTOBuilderImpl(String packageName, String name) {
        super(packageName, name);
        this.setAbstract(false);
    }

    public GeneratedTOBuilder setExtendsType(GeneratedTransferObject genTransObj) {
        if (genTransObj == null) {
            throw new IllegalArgumentException("Generated Transfer Object cannot be null!");
        }
        this.extendsType = genTransObj;
        return this;
    }

    @Override
    public MethodSignatureBuilder addMethod(String name) {
        MethodSignatureBuilder builder = super.addMethod(name);
        builder.setAbstract(false);
        return builder;
    }

    public GeneratedTOBuilder addEqualsIdentity(GeneratedPropertyBuilder property) {
        this.equalsProperties.add(property);
        return this;
    }

    public GeneratedTOBuilder addHashIdentity(GeneratedPropertyBuilder property) {
        this.hashProperties.add(property);
        return this;
    }

    public GeneratedTOBuilder addToStringProperty(GeneratedPropertyBuilder property) {
        this.toStringProperties.add(property);
        return this;
    }

    @Override
    protected GeneratedTOBuilder thisInstance() {
        return this;
    }

    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    public void setSUID(GeneratedPropertyBuilder suid) {
        this.SUID = suid;
    }

    public GeneratedTransferObject toInstance() {
        return new GeneratedTransferObjectImpl(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedTransferObject [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", constants=");
        builder.append(this.getConstants());
        builder.append(", enumerations=");
        builder.append(this.getEnumerations());
        builder.append(", equalsProperties=");
        builder.append(this.equalsProperties);
        builder.append(", hashCodeProperties=");
        builder.append(this.hashProperties);
        builder.append(", stringProperties=");
        builder.append(this.toStringProperties);
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append(", methods=");
        builder.append(this.getMethodDefinitions());
        builder.append("]");
        return builder.toString();
    }

    public void setTypedef(boolean isTypedef) {
        this.isTypedef = isTypedef;
    }

    public void setIsUnion(boolean isUnion) {
        this.isUnionType = isUnion;
    }

    public void setIsUnionBuilder(boolean isUnionTypeBuilder) {
        this.isUnionTypeBuilder = isUnionTypeBuilder;
    }

    private static final class GeneratedTransferObjectImpl
    extends AbstractGeneratedType
    implements GeneratedTransferObject {
        private final List<GeneratedProperty> equalsProperties;
        private final List<GeneratedProperty> hashCodeProperties;
        private final List<GeneratedProperty> stringProperties;
        private final GeneratedTransferObject extendsType;
        private final boolean isTypedef;
        private final boolean isUnionType;
        private final boolean isUnionTypeBuilder;
        private final Restrictions restrictions;
        private final GeneratedProperty SUID;

        public GeneratedTransferObjectImpl(GeneratedTOBuilderImpl builder) {
            super(builder);
            this.extendsType = builder.extendsType;
            this.equalsProperties = this.toUnmodifiableProperties(builder.equalsProperties);
            this.hashCodeProperties = this.toUnmodifiableProperties(builder.hashProperties);
            this.stringProperties = this.toUnmodifiableProperties(builder.toStringProperties);
            this.isTypedef = builder.isTypedef;
            this.isUnionType = builder.isUnionType;
            this.isUnionTypeBuilder = builder.isUnionTypeBuilder;
            this.restrictions = builder.restrictions;
            this.SUID = builder.SUID == null ? null : builder.SUID.toInstance((Type)this);
        }

        public boolean isTypedef() {
            return this.isTypedef;
        }

        public boolean isUnionType() {
            return this.isUnionType;
        }

        public boolean isUnionTypeBuilder() {
            return this.isUnionTypeBuilder;
        }

        public GeneratedTransferObject getSuperType() {
            return this.extendsType;
        }

        public List<GeneratedProperty> getEqualsIdentifiers() {
            return this.equalsProperties;
        }

        public List<GeneratedProperty> getHashCodeIdentifiers() {
            return this.hashCodeProperties;
        }

        public List<GeneratedProperty> getToStringIdentifiers() {
            return this.stringProperties;
        }

        public Restrictions getRestrictions() {
            return this.restrictions;
        }

        public GeneratedProperty getSUID() {
            return this.SUID;
        }

        @Override
        public String toString() {
            if (this.isTypedef) {
                return this.serializeTypedef(this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("GeneratedTransferObject [packageName=");
            builder.append(this.getPackageName());
            builder.append(", name=");
            builder.append(this.getName());
            builder.append(", comment=");
            builder.append(", annotations=");
            builder.append(this.getAnnotations());
            builder.append(this.getComment());
            builder.append(", extends=");
            builder.append(this.getSuperType());
            builder.append(", implements=");
            builder.append(this.getImplements());
            builder.append(", enclosedTypes=");
            builder.append(this.getEnclosedTypes());
            builder.append(", constants=");
            builder.append(this.getConstantDefinitions());
            builder.append(", enumerations=");
            builder.append(this.getEnumerations());
            builder.append(", properties=");
            builder.append(this.getProperties());
            builder.append(", equalsProperties=");
            builder.append(this.equalsProperties);
            builder.append(", hashCodeProperties=");
            builder.append(this.hashCodeProperties);
            builder.append(", stringProperties=");
            builder.append(this.stringProperties);
            builder.append(", methods=");
            builder.append(this.getMethodDefinitions());
            builder.append("]");
            return builder.toString();
        }

        public String serializeTypedef(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                StringBuffer sb = new StringBuffer();
                sb.append(parameterizedType.getRawType().getFullyQualifiedName());
                sb.append("<");
                boolean first = true;
                for (Type parameter : parameterizedType.getActualTypeArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(this.serializeTypedef(parameter));
                }
                sb.append(">");
                return sb.toString();
            }
            return type.getFullyQualifiedName();
        }
    }
}

