/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

public final class EnumerationBuilderImpl
extends AbstractBaseType
implements EnumBuilder {
    private final String packageName;
    private final String name;
    private final List<Enumeration.Pair> values;
    private final List<AnnotationTypeBuilder> annotationBuilders = new ArrayList<AnnotationTypeBuilder>();

    public EnumerationBuilderImpl(String packageName, String name) {
        super(packageName, name);
        this.packageName = packageName;
        this.name = name;
        this.values = new ArrayList<Enumeration.Pair>();
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        AnnotationTypeBuilderImpl builder;
        if (packageName != null && name != null && this.annotationBuilders.add(builder = new AnnotationTypeBuilderImpl(packageName, name))) {
            return builder;
        }
        return null;
    }

    public void addValue(String name, Integer value) {
        this.values.add(new EnumPairImpl(name, value));
    }

    public Enumeration toInstance(Type definingType) {
        return new EnumerationImpl(definingType, this.annotationBuilders, this.packageName, this.name, this.values);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumerationBuilderImpl other = (EnumerationBuilderImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EnumerationBuilderImpl [packageName=");
        builder.append(this.packageName);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", values=");
        builder.append(this.values);
        builder.append("]");
        return builder.toString();
    }

    public void updateEnumPairsFromEnumTypeDef(EnumTypeDefinition enumTypeDef) {
        List enums = enumTypeDef.getValues();
        if (enums != null) {
            int listIndex = 0;
            for (EnumTypeDefinition.EnumPair enumPair : enums) {
                if (enumPair == null) continue;
                String enumPairName = BindingGeneratorUtil.parseToClassName(enumPair.getName());
                Integer enumPairValue = enumPair.getValue();
                if (enumPairValue == null) {
                    enumPairValue = listIndex;
                }
                this.addValue(enumPairName, enumPairValue);
                ++listIndex;
            }
        }
    }

    private static final class EnumerationImpl
    implements Enumeration {
        private final Type definingType;
        private final String packageName;
        private final String name;
        private final List<Enumeration.Pair> values;
        private List<AnnotationType> annotations = new ArrayList<AnnotationType>();

        public EnumerationImpl(Type definingType, List<AnnotationTypeBuilder> annotationBuilders, String packageName, String name, List<Enumeration.Pair> values) {
            this.definingType = definingType;
            for (AnnotationTypeBuilder builder : annotationBuilders) {
                this.annotations.add(builder.toInstance());
            }
            this.annotations = Collections.unmodifiableList(this.annotations);
            this.packageName = packageName;
            this.name = name;
            this.values = Collections.unmodifiableList(values);
        }

        public Type getParentType() {
            return this.definingType;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getName() {
            return this.name;
        }

        public String getFullyQualifiedName() {
            return this.packageName + "." + this.name;
        }

        public List<Enumeration.Pair> getValues() {
            return this.values;
        }

        public List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        public String toFormattedString() {
            StringBuilder builder = new StringBuilder();
            builder.append("public enum");
            builder.append(" ");
            builder.append(this.name);
            builder.append(" {");
            builder.append("\n");
            int i = 0;
            for (Enumeration.Pair valPair : this.values) {
                builder.append("\t");
                builder.append(" ");
                builder.append(valPair.getName());
                builder.append(" (");
                builder.append(valPair.getValue());
                if (i == this.values.size() - 1) {
                    builder.append(" );");
                } else {
                    builder.append(" ),");
                }
                ++i;
            }
            builder.append("\n}");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumerationImpl other = (EnumerationImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
                return false;
            }
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Enumeration [packageName=");
            builder.append(this.packageName);
            if (this.definingType != null) {
                builder.append(", definingType=");
                builder.append(this.definingType.getPackageName());
                builder.append(".");
                builder.append(this.definingType.getName());
            } else {
                builder.append(", definingType= null");
            }
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }

        public String getComment() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public List<Type> getImplements() {
            return Collections.emptyList();
        }

        public List<GeneratedType> getEnclosedTypes() {
            return Collections.emptyList();
        }

        public List<Enumeration> getEnumerations() {
            return Collections.emptyList();
        }

        public List<Constant> getConstantDefinitions() {
            return Collections.emptyList();
        }

        public List<MethodSignature> getMethodDefinitions() {
            return Collections.emptyList();
        }

        public List<GeneratedProperty> getProperties() {
            return Collections.emptyList();
        }
    }

    private static final class EnumPairImpl
    implements Enumeration.Pair {
        private final String name;
        private final Integer value;

        public EnumPairImpl(String name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPairImpl other = (EnumPairImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EnumPair [name=");
            builder.append(this.name);
            builder.append(", value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }
    }
}

