/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Type;

final class ConstantImpl
implements Constant {
    private final Type definingType;
    private final Type type;
    private final String name;
    private final Object value;

    public ConstantImpl(Type definingType, Type type, String name, Object value) {
        this.definingType = definingType;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Type getDefiningType() {
        return this.definingType;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        builder.append(" ");
        builder.append(this.name);
        builder.append(" ");
        builder.append(this.value);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantImpl other = (ConstantImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Constant [type=");
        builder.append(this.type);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", value=");
        builder.append(this.value);
        if (this.definingType != null) {
            builder.append(", definingType=");
            builder.append(this.definingType.getPackageName());
            builder.append(".");
            builder.append(this.definingType.getName());
        } else {
            builder.append(", definingType= null");
        }
        builder.append("]");
        return builder.toString();
    }
}

