/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;

final class AnnotationTypeBuilderImpl
extends AbstractBaseType
implements AnnotationTypeBuilder {
    private final String packageName;
    private final String name;
    private final List<AnnotationTypeBuilder> annotationBuilders;
    private final List<AnnotationType.Parameter> parameters;

    public AnnotationTypeBuilderImpl(String packageName, String name) {
        super(packageName, name);
        this.packageName = packageName;
        this.name = name;
        this.annotationBuilders = new ArrayList<AnnotationTypeBuilder>();
        this.parameters = new ArrayList<AnnotationType.Parameter>();
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        AnnotationTypeBuilderImpl builder;
        if (packageName != null && name != null && this.annotationBuilders.add(builder = new AnnotationTypeBuilderImpl(packageName, name))) {
            return builder;
        }
        return null;
    }

    public boolean addParameter(String paramName, String value) {
        if (paramName != null && value != null) {
            return this.parameters.add(new ParameterImpl(paramName, value));
        }
        return false;
    }

    public boolean addParameters(String paramName, List<String> values) {
        if (paramName != null && values != null) {
            return this.parameters.add(new ParameterImpl(paramName, values));
        }
        return false;
    }

    public AnnotationType toInstance() {
        return new AnnotationTypeImpl(this.packageName, this.name, this.annotationBuilders, this.parameters);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationTypeBuilderImpl other = (AnnotationTypeBuilderImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotationTypeBuilder [packageName=");
        builder.append(this.packageName);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", annotationBuilders=");
        builder.append(this.annotationBuilders);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append("]");
        return builder.toString();
    }

    private static final class ParameterImpl
    implements AnnotationType.Parameter {
        private final String name;
        private final String value;
        private final List<String> values;

        public ParameterImpl(String name, String value) {
            this.name = name;
            this.value = value;
            this.values = Collections.emptyList();
        }

        public ParameterImpl(String name, List<String> values) {
            this.name = name;
            this.values = values;
            this.value = null;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterImpl other = (ParameterImpl)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ParameterImpl [name=");
            builder.append(this.name);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class AnnotationTypeImpl
    implements AnnotationType {
        private final String packageName;
        private final String name;
        private List<AnnotationType> annotations;
        private final List<AnnotationType.Parameter> parameters;
        private List<String> paramNames;

        public AnnotationTypeImpl(String packageName, String name, List<AnnotationTypeBuilder> annotationBuilders, List<AnnotationType.Parameter> parameters) {
            this.packageName = packageName;
            this.name = name;
            this.annotations = new ArrayList<AnnotationType>();
            for (AnnotationTypeBuilder builder : annotationBuilders) {
                this.annotations.add(builder.toInstance());
            }
            this.annotations = Collections.unmodifiableList(this.annotations);
            this.parameters = Collections.unmodifiableList(parameters);
            this.paramNames = new ArrayList<String>();
            for (AnnotationType.Parameter parameter : parameters) {
                this.paramNames.add(parameter.getName());
            }
            this.paramNames = Collections.unmodifiableList(this.paramNames);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getName() {
            return this.name;
        }

        public String getFullyQualifiedName() {
            return this.packageName + "." + this.name;
        }

        public List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        public AnnotationType.Parameter getParameter(String paramName) {
            if (paramName != null) {
                for (AnnotationType.Parameter parameter : this.parameters) {
                    if (!parameter.getName().equals(paramName)) continue;
                    return parameter;
                }
            }
            return null;
        }

        public List<AnnotationType.Parameter> getParameters() {
            return this.parameters;
        }

        public List<String> getParameterNames() {
            return this.paramNames;
        }

        public boolean containsParameters() {
            return !this.parameters.isEmpty();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationTypeImpl other = (AnnotationTypeImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AnnotationType [packageName=");
            builder.append(this.packageName);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", annotations=");
            builder.append(this.annotations);
            builder.append(", parameters=");
            builder.append(this.parameters);
            builder.append("]");
            return builder.toString();
        }
    }
}

