/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.MethodSignatureBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.TypeMemberBuilder;

abstract class AbstractTypeMemberBuilder<T extends TypeMemberBuilder<T>>
implements TypeMemberBuilder<T> {
    private final String name;
    private Type returnType;
    private final List<AnnotationTypeBuilder> annotationBuilders;
    private String comment = "";
    private boolean isFinal;
    private boolean isStatic;
    private AccessModifier accessModifier;

    public AbstractTypeMemberBuilder(String name) {
        this.name = name;
        this.annotationBuilders = new ArrayList<AnnotationTypeBuilder>();
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        if (packageName == null) {
            throw new IllegalArgumentException("Annotation Type cannot have package name null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Annotation Type cannot have name as null!");
        }
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(packageName, name);
        this.annotationBuilders.add(builder);
        return builder;
    }

    protected Type getReturnType() {
        return this.returnType;
    }

    protected List<AnnotationTypeBuilder> getAnnotationBuilders() {
        return this.annotationBuilders;
    }

    protected String getComment() {
        return this.comment;
    }

    protected boolean isFinal() {
        return this.isFinal;
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public String getName() {
        return this.name;
    }

    protected abstract T thisInstance();

    public T setReturnType(Type returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException("Return Type of member cannot be null!");
        }
        this.returnType = returnType;
        return this.thisInstance();
    }

    public T setAccessModifier(AccessModifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException("Access Modifier for member type cannot be null!");
        }
        this.accessModifier = modifier;
        return this.thisInstance();
    }

    public T setComment(String comment) {
        if (comment == null) {
            this.comment = "";
        }
        this.comment = comment;
        return this.thisInstance();
    }

    public T setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this.thisInstance();
    }

    public T setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this.thisInstance();
    }

    protected List<AnnotationType> toAnnotationTypes() {
        ArrayList<AnnotationType> annotations = new ArrayList<AnnotationType>();
        for (AnnotationTypeBuilder annotBuilder : this.getAnnotationBuilders()) {
            if (annotBuilder == null) continue;
            annotations.add(annotBuilder.toInstance());
        }
        return annotations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureBuilderImpl other = (MethodSignatureBuilderImpl)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedPropertyImpl [name=");
        builder.append(this.getName());
        builder.append(", annotations=");
        builder.append(this.getAnnotationBuilders());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", isFinal=");
        builder.append(this.isFinal());
        builder.append(", modifier=");
        builder.append(this.getAccessModifier());
        builder.append("]");
        return builder.toString();
    }
}

