/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.ConstantImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.EnumerationBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.MethodSignatureBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;

abstract class AbstractGeneratedTypeBuilder<T extends GeneratedTypeBuilderBase<T>>
extends AbstractBaseType
implements GeneratedTypeBuilderBase<T> {
    private String comment = "";
    private final List<AnnotationTypeBuilder> annotationBuilders = new ArrayList<AnnotationTypeBuilder>();
    private final List<Type> implementsTypes = new ArrayList<Type>();
    private final List<EnumBuilder> enumDefinitions = new ArrayList<EnumBuilder>();
    private final List<Constant> constants = new ArrayList<Constant>();
    private final List<MethodSignatureBuilder> methodDefinitions = new ArrayList<MethodSignatureBuilder>();
    private final List<GeneratedTypeBuilder> enclosedTypes = new ArrayList<GeneratedTypeBuilder>();
    private final List<GeneratedTOBuilder> enclosedTransferObjects = new ArrayList<GeneratedTOBuilder>();
    private final List<GeneratedPropertyBuilder> properties = new ArrayList<GeneratedPropertyBuilder>();
    private boolean isAbstract;

    public AbstractGeneratedTypeBuilder(String packageName, String name) {
        super(packageName, name);
    }

    protected String getComment() {
        return this.comment;
    }

    protected List<AnnotationTypeBuilder> getAnnotations() {
        return this.annotationBuilders;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<Type> getImplementsTypes() {
        return this.implementsTypes;
    }

    protected List<EnumBuilder> getEnumerations() {
        return this.enumDefinitions;
    }

    protected List<Constant> getConstants() {
        return this.constants;
    }

    public List<MethodSignatureBuilder> getMethodDefinitions() {
        return this.methodDefinitions;
    }

    protected List<GeneratedTypeBuilder> getEnclosedTypes() {
        return this.enclosedTypes;
    }

    protected List<GeneratedTOBuilder> getEnclosedTransferObjects() {
        return this.enclosedTransferObjects;
    }

    protected abstract T thisInstance();

    public GeneratedTOBuilder addEnclosingTransferObject(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name for Enclosing Generated Transfer Object cannot be null!");
        }
        GeneratedTOBuilderImpl builder = new GeneratedTOBuilderImpl(this.getFullyQualifiedName(), name);
        this.enclosedTransferObjects.add(builder);
        return builder;
    }

    public T addEnclosingTransferObject(GeneratedTOBuilder genTOBuilder) {
        if (genTOBuilder == null) {
            throw new IllegalArgumentException("Parameter genTOBuilder cannot be null!");
        }
        this.enclosedTransferObjects.add(genTOBuilder);
        return this.thisInstance();
    }

    public T addComment(String comment) {
        this.comment = comment;
        return this.thisInstance();
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        if (packageName == null) {
            throw new IllegalArgumentException("Package Name for Annotation Type cannot be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name of Annotation Type cannot be null!");
        }
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(packageName, name);
        this.annotationBuilders.add(builder);
        return builder;
    }

    public T setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this.thisInstance();
    }

    public T addImplementsType(Type genType) {
        if (genType == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.implementsTypes.add(genType);
        return this.thisInstance();
    }

    public Constant addConstant(Type type, String name, Object value) {
        if (type == null) {
            throw new IllegalArgumentException("Returning Type for Constant cannot be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name of constant cannot be null!");
        }
        ConstantImpl constant = new ConstantImpl(this, type, name, value);
        this.constants.add(constant);
        return constant;
    }

    public EnumBuilder addEnumeration(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name of enumeration cannot be null!");
        }
        EnumerationBuilderImpl builder = new EnumerationBuilderImpl(this.getFullyQualifiedName(), name);
        this.enumDefinitions.add(builder);
        return builder;
    }

    public MethodSignatureBuilder addMethod(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name of method cannot be null!");
        }
        MethodSignatureBuilderImpl builder = new MethodSignatureBuilderImpl(name);
        builder.setAccessModifier(AccessModifier.PUBLIC);
        builder.setAbstract(true);
        this.methodDefinitions.add(builder);
        return builder;
    }

    public boolean containsMethod(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name can't be null");
        }
        for (MethodSignatureBuilder methodDefinition : this.methodDefinitions) {
            if (!name.equals(methodDefinition.getName())) continue;
            return true;
        }
        return false;
    }

    public GeneratedPropertyBuilder addProperty(String name) {
        GeneratedPropertyBuilderImpl builder = new GeneratedPropertyBuilderImpl(name);
        builder.setAccessModifier(AccessModifier.PUBLIC);
        this.properties.add(builder);
        return builder;
    }

    public boolean containsProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name can't be null");
        }
        for (GeneratedPropertyBuilder property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeneratedTypeBuilder other = (AbstractGeneratedTypeBuilder)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getPackageName() == null ? other.getPackageName() != null : !this.getPackageName().equals(other.getPackageName()));
    }

    public Type getParent() {
        return null;
    }

    public List<GeneratedPropertyBuilder> getProperties() {
        return this.properties;
    }
}

