/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractGeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;

abstract class AbstractGeneratedType
extends AbstractBaseType
implements GeneratedType {
    private final Type parent;
    private final String comment;
    private final List<AnnotationType> annotations;
    private final List<Type> implementsTypes;
    private final List<Enumeration> enumerations;
    private final List<Constant> constants;
    private final List<MethodSignature> methodSignatures;
    private final List<GeneratedType> enclosedTypes;
    private final List<GeneratedProperty> properties;
    private final boolean isAbstract;

    public AbstractGeneratedType(AbstractGeneratedTypeBuilder builder) {
        super(builder.getPackageName(), builder.getName());
        this.parent = builder.getParent();
        this.comment = builder.getComment();
        this.annotations = this.toUnmodifiableAnnotations(builder.getAnnotations());
        this.implementsTypes = Collections.unmodifiableList(builder.getImplementsTypes());
        this.constants = Collections.unmodifiableList(builder.getConstants());
        this.enumerations = this.toUnmodifiableEnumerations(builder.getEnumerations());
        this.methodSignatures = this.toUnmodifiableMethods(builder.getMethodDefinitions());
        this.enclosedTypes = this.toUnmodifiableEnclosedTypes(builder.getEnclosedTypes(), builder.getEnclosedTransferObjects());
        this.properties = this.toUnmodifiableProperties(builder.getProperties());
        this.isAbstract = builder.isAbstract();
    }

    public AbstractGeneratedType(Type parent, String packageName, String name, String comment, List<AnnotationTypeBuilder> annotationBuilders, boolean isAbstract, List<Type> implementsTypes, List<GeneratedTypeBuilder> enclosedGenTypeBuilders, List<GeneratedTOBuilder> enclosedGenTOBuilders, List<EnumBuilder> enumBuilders, List<Constant> constants, List<MethodSignatureBuilder> methodBuilders, List<GeneratedPropertyBuilder> propertyBuilders) {
        super(packageName, name);
        this.parent = parent;
        this.comment = comment;
        this.annotations = this.toUnmodifiableAnnotations(annotationBuilders);
        this.implementsTypes = Collections.unmodifiableList(implementsTypes);
        this.constants = Collections.unmodifiableList(constants);
        this.enumerations = this.toUnmodifiableEnumerations(enumBuilders);
        this.methodSignatures = this.toUnmodifiableMethods(methodBuilders);
        this.enclosedTypes = this.toUnmodifiableEnclosedTypes(enclosedGenTypeBuilders, enclosedGenTOBuilders);
        this.properties = this.toUnmodifiableProperties(propertyBuilders);
        this.isAbstract = isAbstract;
    }

    private List<GeneratedType> toUnmodifiableEnclosedTypes(List<GeneratedTypeBuilder> enclosedGenTypeBuilders, List<GeneratedTOBuilder> enclosedGenTOBuilders) {
        ArrayList<GeneratedType> enclosedTypesList = new ArrayList<GeneratedType>();
        for (GeneratedTypeBuilder generatedTypeBuilder : enclosedGenTypeBuilders) {
            if (generatedTypeBuilder == null) continue;
            enclosedTypesList.add(generatedTypeBuilder.toInstance());
        }
        for (GeneratedTOBuilder generatedTOBuilder : enclosedGenTOBuilders) {
            if (generatedTOBuilder == null) continue;
            enclosedTypesList.add((GeneratedType)generatedTOBuilder.toInstance());
        }
        return enclosedTypesList;
    }

    protected final List<AnnotationType> toUnmodifiableAnnotations(List<AnnotationTypeBuilder> annotationBuilders) {
        ArrayList<AnnotationType> annotationList = new ArrayList<AnnotationType>();
        for (AnnotationTypeBuilder builder : annotationBuilders) {
            annotationList.add(builder.toInstance());
        }
        return Collections.unmodifiableList(annotationList);
    }

    protected final List<MethodSignature> toUnmodifiableMethods(List<MethodSignatureBuilder> methodBuilders) {
        ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
        for (MethodSignatureBuilder methodBuilder : methodBuilders) {
            methods.add(methodBuilder.toInstance((Type)this));
        }
        return Collections.unmodifiableList(methods);
    }

    protected final List<Enumeration> toUnmodifiableEnumerations(List<EnumBuilder> enumBuilders) {
        ArrayList<Enumeration> enums = new ArrayList<Enumeration>();
        for (EnumBuilder enumBuilder : enumBuilders) {
            enums.add(enumBuilder.toInstance((Type)this));
        }
        return Collections.unmodifiableList(enums);
    }

    protected final List<GeneratedProperty> toUnmodifiableProperties(List<GeneratedPropertyBuilder> methodBuilders) {
        ArrayList<GeneratedProperty> methods = new ArrayList<GeneratedProperty>();
        for (GeneratedPropertyBuilder methodBuilder : methodBuilders) {
            methods.add(methodBuilder.toInstance((Type)this));
        }
        return Collections.unmodifiableList(methods);
    }

    public final Type getParentType() {
        return this.parent;
    }

    public final String getComment() {
        return this.comment;
    }

    public final List<AnnotationType> getAnnotations() {
        return this.annotations;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    public final List<Type> getImplements() {
        return this.implementsTypes;
    }

    public final List<GeneratedType> getEnclosedTypes() {
        return this.enclosedTypes;
    }

    public final List<Enumeration> getEnumerations() {
        return this.enumerations;
    }

    public final List<Constant> getConstantDefinitions() {
        return this.constants;
    }

    public final List<MethodSignature> getMethodDefinitions() {
        return this.methodSignatures;
    }

    public final List<GeneratedProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedType [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        if (this.parent != null) {
            builder.append(", parent=");
            builder.append(this.parent.getFullyQualifiedName());
        } else {
            builder.append(", parent=null");
        }
        builder.append(", comment=");
        builder.append(this.comment);
        builder.append(", annotations=");
        builder.append(this.annotations);
        builder.append(", enclosedTypes=");
        builder.append(this.enclosedTypes);
        builder.append(", enumerations=");
        builder.append(this.enumerations);
        builder.append(", constants=");
        builder.append(this.constants);
        builder.append(", methodSignatures=");
        builder.append(this.methodSignatures);
        builder.append("]");
        return builder.toString();
    }
}

