/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;

public final class BindingGeneratorUtil {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyMMdd");
    @Deprecated
    private static final String[] SET_VALUES = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    @Deprecated
    private static final Set<String> JAVA_RESERVED_WORDS = new HashSet<String>(Arrays.asList(SET_VALUES));

    private BindingGeneratorUtil() {
    }

    private static String validateJavaPackage(String packageName) {
        String[] packNameParts;
        if (packageName != null && (packNameParts = packageName.toLowerCase().split("\\.")) != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < packNameParts.length; ++i) {
                String packNamePart = packNameParts[i];
                if (Character.isDigit(packNamePart.charAt(0))) {
                    packNameParts[i] = "_" + packNamePart;
                } else if (JAVA_RESERVED_WORDS.contains(packNamePart)) {
                    packNameParts[i] = "_" + packNamePart;
                }
                if (i > 0) {
                    builder.append(".");
                }
                builder.append(packNameParts[i]);
            }
            return builder.toString();
        }
        return packageName;
    }

    public static String resolveJavaReservedWordEquivalency(String parameterName) {
        if (parameterName != null && JAVA_RESERVED_WORDS.contains(parameterName)) {
            return "_" + parameterName;
        }
        return parameterName;
    }

    public static String moduleNamespaceToPackageName(Module module) {
        StringBuilder packageNameBuilder = new StringBuilder();
        if (module.getRevision() == null) {
            throw new IllegalArgumentException("Module " + module.getName() + " does not specify revision date!");
        }
        packageNameBuilder.append("org.opendaylight.yang.gen.v");
        packageNameBuilder.append(module.getYangVersion());
        packageNameBuilder.append(".");
        String namespace = module.getNamespace().toString();
        namespace = namespace.replace("://", ".");
        namespace = namespace.replace("/", ".");
        namespace = namespace.replace(":", ".");
        namespace = namespace.replace("-", ".");
        namespace = namespace.replace("@", ".");
        namespace = namespace.replace("$", ".");
        namespace = namespace.replace("#", ".");
        namespace = namespace.replace("'", ".");
        namespace = namespace.replace("*", ".");
        namespace = namespace.replace("+", ".");
        namespace = namespace.replace(",", ".");
        namespace = namespace.replace(";", ".");
        namespace = namespace.replace("=", ".");
        packageNameBuilder.append(namespace);
        packageNameBuilder.append(".rev");
        packageNameBuilder.append(DATE_FORMAT.format(module.getRevision()));
        return BindingGeneratorUtil.validateJavaPackage(packageNameBuilder.toString());
    }

    public static String packageNameForGeneratedType(String basePackageName, SchemaPath schemaPath) {
        if (basePackageName == null) {
            throw new IllegalArgumentException("Base Package Name cannot be NULL!");
        }
        if (schemaPath == null) {
            throw new IllegalArgumentException("Schema Path cannot be NULL!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(basePackageName);
        List pathToNode = schemaPath.getPath();
        int traversalSteps = pathToNode.size() - 1;
        for (int i = 0; i < traversalSteps; ++i) {
            builder.append(".");
            String nodeLocalName = ((QName)pathToNode.get(i)).getLocalName();
            nodeLocalName = nodeLocalName.replace(":", ".");
            nodeLocalName = nodeLocalName.replace("-", ".");
            builder.append(nodeLocalName);
        }
        return BindingGeneratorUtil.validateJavaPackage(builder.toString());
    }

    public static String packageNameForTypeDefinition(String basePackageName, TypeDefinition<?> typeDefinition) {
        if (basePackageName == null) {
            throw new IllegalArgumentException("Base Package Name cannot be NULL!");
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Type Definition reference cannot be NULL!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(basePackageName);
        return BindingGeneratorUtil.validateJavaPackage(builder.toString());
    }

    @Deprecated
    public static String parseToClassName(String token) {
        return BindingGeneratorUtil.parseToCamelCase(token, true);
    }

    public static String parseToValidParamName(String token) {
        return BindingGeneratorUtil.resolveJavaReservedWordEquivalency(BindingGeneratorUtil.parseToCamelCase(token, false));
    }

    private static String parseToCamelCase(String token, boolean uppercase) {
        if (token == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        String correctStr = token.trim();
        if ((correctStr = correctStr.replace(".", "")).isEmpty()) {
            throw new IllegalArgumentException("Name can not be emty");
        }
        correctStr = BindingGeneratorUtil.replaceWithCamelCase(correctStr, ' ');
        correctStr = BindingGeneratorUtil.replaceWithCamelCase(correctStr, '-');
        correctStr = BindingGeneratorUtil.replaceWithCamelCase(correctStr, '_');
        String firstChar = correctStr.substring(0, 1);
        firstChar = uppercase ? firstChar.toUpperCase() : firstChar.toLowerCase();
        correctStr = firstChar.matches("[0-9]") ? "_" + correctStr : firstChar + correctStr.substring(1);
        return correctStr;
    }

    private static String replaceWithCamelCase(String text, char removalChar) {
        StringBuilder sb = new StringBuilder(text);
        String toBeRemoved = String.valueOf(removalChar);
        int toBeRemovedPos = sb.indexOf(toBeRemoved);
        while (toBeRemovedPos != -1) {
            sb.replace(toBeRemovedPos, toBeRemovedPos + 1, "");
            if (sb.length() == 0) {
                throw new IllegalArgumentException("The resulting string can not be empty");
            }
            String replacement = String.valueOf(sb.charAt(toBeRemovedPos)).toUpperCase();
            sb.setCharAt(toBeRemovedPos, replacement.charAt(0));
            toBeRemovedPos = sb.indexOf(toBeRemoved);
        }
        return sb.toString();
    }

    public static long computeDefaultSUID(GeneratedTOBuilderImpl to) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(to.getName());
            dout.writeInt(to.isAbstract() ? 3 : 7);
            List impl = to.getImplementsTypes();
            Collections.sort(impl, new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
                }
            });
            for (Type ifc : impl) {
                dout.writeUTF(ifc.getFullyQualifiedName());
            }
            Comparator comparator = new Comparator<TypeMemberBuilder<?>>(){

                @Override
                public int compare(TypeMemberBuilder<?> o1, TypeMemberBuilder<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            List props = to.getProperties();
            Collections.sort(props, comparator);
            for (GeneratedPropertyBuilder gp : props) {
                dout.writeUTF(gp.getName());
            }
            List methods = to.getMethodDefinitions();
            Collections.sort(methods, comparator);
            for (MethodSignatureBuilder m : methods) {
                if (m.getAccessModifier().equals((Object)AccessModifier.PRIVATE)) continue;
                dout.writeUTF(m.getName());
                dout.write(m.getAccessModifier().ordinal());
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    public static Restrictions getRestrictions(TypeDefinition<?> type) {
        final ArrayList length = new ArrayList();
        final ArrayList pattern = new ArrayList();
        final ArrayList range = new ArrayList();
        if (type instanceof ExtendedType) {
            ExtendedType ext = (ExtendedType)type;
            TypeDefinition base = ext.getBaseType();
            length.addAll(ext.getLengthConstraints());
            pattern.addAll(ext.getPatternConstraints());
            range.addAll(ext.getRangeConstraints());
            if (base instanceof IntegerTypeDefinition && range.isEmpty()) {
                range.addAll(((IntegerTypeDefinition)base).getRangeConstraints());
            } else if (base instanceof UnsignedIntegerTypeDefinition && range.isEmpty()) {
                range.addAll(((UnsignedIntegerTypeDefinition)base).getRangeConstraints());
            } else if (base instanceof DecimalTypeDefinition && range.isEmpty()) {
                range.addAll(((DecimalTypeDefinition)base).getRangeConstraints());
            }
        }
        return new Restrictions(){

            public List<RangeConstraint> getRangeConstraints() {
                return range;
            }

            public List<PatternConstraint> getPatternConstraints() {
                return pattern;
            }

            public List<LengthConstraint> getLengthConstraints() {
                return length;
            }

            public boolean isEmpty() {
                return range.isEmpty() && pattern.isEmpty() && length.isEmpty();
            }
        };
    }
}

