/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util;

import org.opendaylight.yangtools.sal.binding.model.api.Type;

public class AbstractBaseType
implements Type {
    private final String packageName;
    private final String name;

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        if (this.packageName.isEmpty()) {
            return this.name;
        }
        return this.packageName + "." + this.name;
    }

    protected AbstractBaseType(String pkName, String name) {
        if (pkName == null) {
            throw new IllegalArgumentException("Package Name for Generated Type cannot be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name of Generated Type cannot be null!");
        }
        this.packageName = pkName;
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        return !(this.packageName == null ? other.getPackageName() != null : !this.packageName.equals(other.getPackageName()));
    }

    public String toString() {
        if (this.packageName.isEmpty()) {
            return "Type (" + this.name + ")";
        }
        return "Type (" + this.packageName + "." + this.name + ")";
    }
}

