/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.eventexecutor;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.netty.eventexecutor.AbstractGlobalEventExecutorModule;

public final class GlobalEventExecutorModule
extends AbstractGlobalEventExecutorModule {
    public GlobalEventExecutorModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public GlobalEventExecutorModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, GlobalEventExecutorModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public AutoCloseable createInstance() {
        return new GlobalEventExecutorCloseable((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    private static final class GlobalEventExecutorCloseable
    extends AbstractEventExecutor
    implements AutoCloseable {
        private EventExecutor executor;

        public GlobalEventExecutorCloseable(EventExecutor executor) {
            this.executor = executor;
        }

        public EventExecutorGroup parent() {
            return this.executor.parent();
        }

        public boolean inEventLoop(Thread thread) {
            return this.executor.inEventLoop(thread);
        }

        public boolean isShuttingDown() {
            return this.executor.isShuttingDown();
        }

        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            return this.executor.shutdownGracefully(quietPeriod, timeout, unit);
        }

        public Future<?> terminationFuture() {
            return this.executor.terminationFuture();
        }

        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public void close() throws Exception {
            this.shutdownGracefully();
        }

        public void shutdown() {
            this.executor.shutdown();
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.executor.schedule(command, delay, unit);
        }

        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.executor.schedule(callable, delay, unit);
        }

        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
        }
    }
}

