/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.ForwardingMode;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.Tier;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;

public class SwitchConfig
extends ConfigurationObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final Map<String, Property> nodeProperties;

    public SwitchConfig(String nodeId, Map<String, Property> nodeProperties) {
        this.nodeId = nodeId;
        this.nodeProperties = nodeProperties == null ? new HashMap<String, Property>() : new HashMap<String, Property>(nodeProperties);
    }

    @Deprecated
    public SwitchConfig(String nodeId, String description, String tier, String mode) {
        this.nodeId = nodeId;
        this.nodeProperties = new HashMap<String, Property>();
        Description desc = new Description(description);
        this.nodeProperties.put(desc.getName(), (Property)desc);
        Tier nodeTier = new Tier(Integer.valueOf(tier).intValue());
        this.nodeProperties.put(nodeTier.getName(), (Property)nodeTier);
        ForwardingMode forwardingMode = new ForwardingMode(Integer.valueOf(mode).intValue());
        this.nodeProperties.put(forwardingMode.getName(), (Property)forwardingMode);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Map<String, Property> getNodeProperties() {
        return new HashMap<String, Property>(this.nodeProperties);
    }

    public Property getProperty(String PropName) {
        return this.nodeProperties.get(PropName);
    }

    @Deprecated
    public String getNodeDescription() {
        Description description = (Description)this.getProperty("description");
        return description == null ? null : description.getValue();
    }

    @Deprecated
    public String getTier() {
        Tier tier = (Tier)this.getProperty("tier");
        return tier == null ? null : String.valueOf(tier.getValue());
    }

    @Deprecated
    public String getMode() {
        ForwardingMode forwardingMode = (ForwardingMode)this.getProperty("forwarding");
        return forwardingMode == null ? null : String.valueOf(forwardingMode.getValue());
    }

    @Deprecated
    public boolean isProactive() {
        return Integer.parseInt(this.getMode()) == 1;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public Status validate() {
        Status validCheck = this.validateNodeId();
        if (validCheck.isSuccess()) {
            validCheck = this.validateNodeProperties();
        }
        return validCheck;
    }

    private Status validateNodeId() {
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "NodeId cannot be empty");
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateNodeProperties() {
        if (this.nodeProperties == null) {
            return new Status(StatusCode.BADREQUEST, "nodeProperties cannot be null");
        }
        return new Status(StatusCode.SUCCESS);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.nodeProperties == null ? 0 : this.nodeProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwitchConfig other = (SwitchConfig)obj;
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        return !(this.nodeProperties == null ? other.nodeProperties != null : !this.nodeProperties.equals(other.nodeProperties));
    }

    public String toString() {
        return "SwitchConfig [Node=" + this.nodeId + ", Properties=" + this.nodeProperties + "]";
    }

    public SwitchConfig clone() {
        HashMap<String, Property> nodeProperties = this.nodeProperties == null ? null : new HashMap<String, Property>(this.nodeProperties);
        return new SwitchConfig(this.nodeId, nodeProperties);
    }
}

