/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.HexEncode;

public class Switch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] dataLayerAddress;
    private Set<NodeConnector> nodeConnectors;
    private final List<NodeConnector> spanPorts;
    private Node node;

    public Switch(Node node) {
        this.node = node;
        this.nodeConnectors = new HashSet<NodeConnector>();
        this.spanPorts = new ArrayList<NodeConnector>(2);
        this.dataLayerAddress = null;
    }

    public byte[] getDataLayerAddress() {
        return this.dataLayerAddress;
    }

    public void setDataLayerAddress(byte[] dataLayerAddress) {
        this.dataLayerAddress = dataLayerAddress == null ? null : (byte[])dataLayerAddress.clone();
    }

    public Set<NodeConnector> getNodeConnectors() {
        return new HashSet<NodeConnector>(this.nodeConnectors);
    }

    public void setNodeConnectors(Set<NodeConnector> nodeConnectors) {
        this.nodeConnectors = nodeConnectors;
    }

    public void addNodeConnector(NodeConnector nodeConnector) {
        if (!this.nodeConnectors.contains(nodeConnector)) {
            this.nodeConnectors.add(nodeConnector);
        }
    }

    public void removeNodeConnector(NodeConnector nodeConnector) {
        this.nodeConnectors.remove(nodeConnector);
    }

    public List<NodeConnector> getSpanPorts() {
        return new ArrayList<NodeConnector>(this.spanPorts);
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void addSpanPorts(List<NodeConnector> portList) {
        for (NodeConnector port : portList) {
            this.spanPorts.add(port);
        }
    }

    public void removeSpanPorts(List<NodeConnector> portList) {
        for (NodeConnector port : portList) {
            this.spanPorts.remove(port);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dataLayerAddress);
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.nodeConnectors == null ? 0 : this.nodeConnectors.hashCode());
        result = 31 * result + (this.spanPorts == null ? 0 : this.spanPorts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Switch other = (Switch)obj;
        if (!Arrays.equals(this.dataLayerAddress, other.dataLayerAddress)) {
            return false;
        }
        if (this.node == null ? other.node != null : !this.node.equals((Object)other.node)) {
            return false;
        }
        if (this.nodeConnectors == null ? other.nodeConnectors != null : !this.nodeConnectors.equals(other.nodeConnectors)) {
            return false;
        }
        return !(this.spanPorts == null ? other.spanPorts != null : !this.spanPorts.equals(other.spanPorts));
    }

    public String toString() {
        return "Switch [dataLayerAddress=" + HexEncode.bytesToHexStringFormat((byte[])this.dataLayerAddress) + ", nodeConnectors=" + this.nodeConnectors + ", spanPorts=" + this.spanPorts + ", node=" + this.node + "]";
    }
}

