/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.utils.GUIField;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SubnetConfig
extends ConfigurationObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] prettyFields = new String[]{GUIField.NAME.toString(), GUIField.GATEWAYIP.toString(), GUIField.NODEPORTS.toString()};
    @XmlElement
    private String name;
    @XmlElement
    private String subnet;
    @XmlElement
    private List<String> nodeConnectors;

    public SubnetConfig() {
    }

    public SubnetConfig(String name, String subnet, List<String> nodeConnectors) {
        this.name = name;
        this.subnet = subnet;
        this.nodeConnectors = nodeConnectors;
    }

    public SubnetConfig(SubnetConfig subnetConfig) {
        this.name = subnetConfig.name;
        this.subnet = subnetConfig.subnet;
        this.nodeConnectors = subnetConfig.nodeConnectors == null ? null : new ArrayList<String>(subnetConfig.nodeConnectors);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNodePorts() {
        return this.nodeConnectors == null ? new ArrayList<String>(0) : new ArrayList<String>(this.nodeConnectors);
    }

    public String getSubnet() {
        return this.subnet;
    }

    public InetAddress getIPAddress() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(this.subnet.split("/")[0]);
        }
        catch (UnknownHostException e1) {
            return null;
        }
        return ip;
    }

    public Short getIPMaskLen() {
        Short maskLen = 0;
        String[] s = this.subnet.split("/");
        try {
            maskLen = s.length == 2 ? Short.valueOf(s[1]) : (short)32;
        }
        catch (NumberFormatException e) {
            maskLen = 32;
        }
        return maskLen;
    }

    private Status validateSubnetAddress() {
        if (!NetUtils.isIPAddressValid((String)this.subnet)) {
            return new Status(StatusCode.BADREQUEST, String.format("Invalid Subnet configuration: Invalid address: %s", this.subnet));
        }
        if (this.getIPMaskLen() == 0 || this.getIPMaskLen() == 32) {
            return new Status(StatusCode.BADREQUEST, String.format("Invalid Subnet configuration: Invalid mask: /%s", this.getIPMaskLen()));
        }
        String address = this.subnet.split("/")[0];
        if (address.startsWith("0.") || address.startsWith("255.")) {
            return new Status(StatusCode.BADREQUEST, String.format("Invalid Subnet configuration: Invalid address: %s", address));
        }
        byte[] bytePrefix = NetUtils.getSubnetPrefix((InetAddress)this.getIPAddress(), (int)this.getIPMaskLen().shortValue()).getAddress();
        long prefix = BitBufferHelper.getLong((byte[])bytePrefix);
        if (prefix == 0L) {
            return new Status(StatusCode.BADREQUEST, "Invalid network source address: subnet zero");
        }
        long hostAddress = BitBufferHelper.getLong((byte[])this.getIPAddress().getAddress()) - prefix;
        if (hostAddress == 0L || (double)hostAddress == Math.pow(2.0, 32 - this.getIPMaskLen()) - 1.0) {
            return new Status(StatusCode.BADREQUEST, String.format("Invalid subnet gateway address: /%s", this.subnet));
        }
        return new Status(StatusCode.SUCCESS);
    }

    public static Status validatePorts(List<String> nodeConnectors) {
        if (nodeConnectors != null) {
            for (String port : nodeConnectors) {
                if (null != NodeConnector.fromString((String)port)) continue;
                return new Status(StatusCode.BADREQUEST, "Invalid Subnet configuration: Not parsable node connector: " + port);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status validateName() {
        if (!this.isValidResourceName(this.name)) {
            return new Status(StatusCode.BADREQUEST, "Invalid name");
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status validate() {
        Status status = this.validateName();
        if (status.isSuccess() && (status = this.validateSubnetAddress()).isSuccess()) {
            status = SubnetConfig.validatePorts(this.nodeConnectors);
        }
        return status;
    }

    public static List<String> getGuiFieldsNames() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String str : prettyFields) {
            fieldList.add(str);
        }
        return fieldList;
    }

    public Set<NodeConnector> getNodeConnectors() {
        return NodeConnector.fromString(this.nodeConnectors);
    }

    public boolean isGlobal() {
        return this.nodeConnectors == null || this.nodeConnectors.isEmpty();
    }

    public void addNodeConnectors(List<String> nc) {
        if (nc != null) {
            if (this.nodeConnectors == null) {
                this.nodeConnectors = new ArrayList<String>(nc);
            } else {
                this.nodeConnectors.addAll(nc);
            }
        }
    }

    public void removeNodeConnectors(List<String> nc) {
        if (nc != null && this.nodeConnectors != null) {
            this.nodeConnectors.removeAll(nc);
        }
    }

    public String toString() {
        return "SubnetConfig [Name=" + this.name + ", Subnet=" + this.subnet + ", NodeConnectors=" + this.nodeConnectors + "]";
    }

    public SubnetConfig clone() {
        return new SubnetConfig(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodeConnectors == null ? 0 : this.nodeConnectors.hashCode());
        result = 31 * result + (this.subnet == null ? 0 : this.subnet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubnetConfig other = (SubnetConfig)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodeConnectors == null ? other.nodeConnectors != null : !this.nodeConnectors.equals(other.nodeConnectors)) {
            return false;
        }
        return !(this.subnet == null ? other.subnet != null : !this.subnet.equals(other.subnet));
    }
}

