/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.switchmanager.SubnetConfig;

public class Subnet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private InetAddress networkAddress;
    private transient InetAddress subnetPrefix;
    private short subnetMaskLength;
    private short vlan;
    private final Set<NodeConnector> nodeConnectors;

    public Subnet(InetAddress ip, short maskLen, short vlan) {
        this.networkAddress = ip;
        this.subnetMaskLength = maskLen;
        this.vlan = vlan;
        this.nodeConnectors = new HashSet<NodeConnector>();
    }

    public Subnet(SubnetConfig conf) {
        this.networkAddress = conf.getIPAddress();
        this.subnetMaskLength = conf.getIPMaskLen();
        this.nodeConnectors = conf.getNodeConnectors();
    }

    public Subnet(Subnet subnet) {
        this.networkAddress = subnet.networkAddress;
        this.subnetMaskLength = subnet.subnetMaskLength;
        this.vlan = subnet.vlan;
        this.nodeConnectors = new HashSet<NodeConnector>(subnet.nodeConnectors);
    }

    public void addNodeConnectors(Set<NodeConnector> sp) {
        if (sp != null) {
            this.nodeConnectors.addAll(sp);
        }
    }

    public void deleteNodeConnectors(Set<NodeConnector> sp) {
        if (sp == null) {
            return;
        }
        for (NodeConnector p : sp) {
            this.nodeConnectors.remove(p);
        }
    }

    public Set<NodeConnector> getNodeConnectors() {
        return this.nodeConnectors;
    }

    public boolean isFlatLayer2() {
        return this.nodeConnectors.isEmpty();
    }

    public InetAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public Subnet setNetworkAddress(InetAddress networkAddress) {
        this.networkAddress = networkAddress;
        this.subnetPrefix = null;
        return this;
    }

    public short getSubnetMaskLength() {
        return this.subnetMaskLength;
    }

    public Subnet setSubnetMaskLength(short m) {
        this.subnetMaskLength = m;
        return this;
    }

    private InetAddress getPrefixForAddress(InetAddress ip) {
        int bytes = this.subnetMaskLength / 8;
        int bits = this.subnetMaskLength % 8;
        byte[] sn = ip.getAddress();
        if (bits > 0) {
            byte modifiedByte = (byte)(sn[bytes] >> 8 - bits);
            sn[bytes] = (byte)(modifiedByte << 8 - bits);
            ++bytes;
        }
        while (bytes < sn.length) {
            sn[bytes] = 0;
            ++bytes;
        }
        try {
            return InetAddress.getByAddress(sn);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public boolean isSubnetOf(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        if (this.subnetPrefix == null) {
            this.subnetPrefix = this.getPrefixForAddress(this.networkAddress);
        }
        InetAddress otherPrefix = this.getPrefixForAddress(ip);
        boolean isSubnetOf = true;
        if (this.subnetPrefix == null || otherPrefix == null || !this.subnetPrefix.equals(otherPrefix)) {
            isSubnetOf = false;
        }
        return isSubnetOf;
    }

    public short getVlan() {
        return this.vlan;
    }

    public Subnet setVlan(short i) {
        this.vlan = i;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.networkAddress == null ? 0 : this.networkAddress.hashCode());
        result = 31 * result + (this.nodeConnectors == null ? 0 : this.nodeConnectors.hashCode());
        result = 31 * result + this.subnetMaskLength;
        result = 31 * result + this.vlan;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subnet other = (Subnet)obj;
        if (this.networkAddress == null ? other.networkAddress != null : !this.networkAddress.equals(other.networkAddress)) {
            return false;
        }
        if (this.nodeConnectors == null ? other.nodeConnectors != null : !this.nodeConnectors.equals(other.nodeConnectors)) {
            return false;
        }
        if (this.subnetMaskLength != other.subnetMaskLength) {
            return false;
        }
        return this.vlan == other.vlan;
    }

    public String toString() {
        return "Subnet [networkAddress=" + this.networkAddress.getHostAddress() + "/" + this.subnetMaskLength + (this.vlan == 0 ? "" : ", vlan=" + this.vlan) + ", " + (this.isFlatLayer2() ? "{[*, *]}" : this.nodeConnectors.toString()) + "]";
    }

    public boolean hasNodeConnector(NodeConnector p) {
        if (p == null) {
            return false;
        }
        return this.isFlatLayer2() || this.nodeConnectors.contains(p);
    }

    public boolean isMutualExclusive(Subnet otherSubnet) {
        return !this.isSubnetOf(otherSubnet.getNetworkAddress()) && !otherSubnet.isSubnetOf(this.getNetworkAddress());
    }

    public Subnet clone() {
        return new Subnet(this);
    }
}

