/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.GUIField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanConfig
extends ConfigurationObject
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(SpanConfig.class);
    private static final long serialVersionUID = 1L;
    private static final String[] guiFields = new String[]{GUIField.NODE.toString(), GUIField.SPANPORTS.toString()};
    private String nodeId;
    private String spanPort;

    public String getNodeId() {
        return this.nodeId;
    }

    public String getSpanPort() {
        return this.spanPort;
    }

    public Node getNode() {
        return Node.fromString((String)this.nodeId);
    }

    private boolean hasValidNodeId() {
        return this.getNode() != null;
    }

    private boolean hasValidSpanPort() {
        return this.spanPort != null && !this.spanPort.isEmpty();
    }

    public boolean isValidConfig() {
        return this.hasValidNodeId() && this.hasValidSpanPort();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.spanPort == null ? 0 : this.spanPort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanConfig other = (SpanConfig)obj;
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        return !(this.spanPort == null ? other.spanPort != null : !this.spanPort.equals(other.spanPort));
    }

    public static ArrayList<String> getFieldsNames() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field fld : SpanConfig.class.getDeclaredFields()) {
            fieldList.add(fld.getName());
        }
        for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
            fieldList.remove(0);
        }
        return fieldList;
    }

    public static List<String> getGuiFieldsNames() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String str : guiFields) {
            fieldList.add(str);
        }
        return fieldList;
    }

    public ArrayList<NodeConnector> getPortArrayList() {
        String[] elemArray;
        ArrayList<NodeConnector> portList = new ArrayList<NodeConnector>();
        for (String elem : elemArray = this.spanPort.split(",")) {
            NodeConnector nodeConnector = NodeConnector.fromString((String)elem);
            if (nodeConnector == null) continue;
            portList.add(nodeConnector);
        }
        return portList;
    }

    public boolean matchNode(String nodeId) {
        return this.nodeId.equals(nodeId);
    }

    public String toString() {
        return "SpanConfig [nodeId=" + this.nodeId + ", spanPort=" + this.spanPort + "]";
    }
}

