/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.switchmanager.SpanConfig;
import org.opendaylight.controller.switchmanager.Subnet;
import org.opendaylight.controller.switchmanager.SubnetConfig;
import org.opendaylight.controller.switchmanager.Switch;
import org.opendaylight.controller.switchmanager.SwitchConfig;

public interface ISwitchManager {
    public Status addSubnet(SubnetConfig var1);

    public Status removeSubnet(SubnetConfig var1);

    public Status modifySubnet(SubnetConfig var1);

    public Status removeSubnet(String var1);

    public List<Switch> getNetworkDevices();

    public Set<Switch> getConfiguredNotConnectedSwitches();

    public List<SubnetConfig> getSubnetsConfigList();

    public SubnetConfig getSubnetConfig(String var1);

    public Subnet getSubnetByNetworkAddress(InetAddress var1);

    public Status saveSwitchConfig();

    public Status addSpanConfig(SpanConfig var1);

    public Status removeSpanConfig(SpanConfig var1);

    public List<SpanConfig> getSpanConfigList();

    public List<NodeConnector> getSpanPorts(Node var1);

    @Deprecated
    public void updateSwitchConfig(SwitchConfig var1);

    public Status updateNodeConfig(SwitchConfig var1);

    public Status removeNodeConfig(String var1);

    public SwitchConfig getSwitchConfig(String var1);

    public Status addPortsToSubnet(String var1, List<String> var2);

    public Status removePortsFromSubnet(String var1, List<String> var2);

    public Set<Node> getNodes();

    public Map<String, Property> getNodeProps(Node var1);

    public Property getNodeProp(Node var1, String var2);

    public void setNodeProp(Node var1, Property var2);

    public Status removeNodeProp(Node var1, String var2);

    public Status removeNodeAllProps(Node var1);

    public Set<NodeConnector> getUpNodeConnectors(Node var1);

    public Set<NodeConnector> getNodeConnectors(Node var1);

    public Set<NodeConnector> getPhysicalNodeConnectors(Node var1);

    public Map<String, Property> getNodeConnectorProps(NodeConnector var1);

    public Property getNodeConnectorProp(NodeConnector var1, String var2);

    public Status addNodeConnectorProp(NodeConnector var1, Property var2);

    public Status removeNodeConnectorProp(NodeConnector var1, String var2);

    public Status removeNodeConnectorAllProps(NodeConnector var1);

    public NodeConnector getNodeConnector(Node var1, String var2);

    public boolean isSpecial(NodeConnector var1);

    public Boolean isNodeConnectorEnabled(NodeConnector var1);

    public boolean doesNodeConnectorExist(NodeConnector var1);

    public byte[] getControllerMAC();

    public byte[] getNodeMAC(Node var1);

    public Property createProperty(String var1, String var2);

    @Deprecated
    public String getNodeDescription(Node var1);

    public Map<String, Property> getControllerProperties();

    public Property getControllerProperty(String var1);

    public Status setControllerProperty(Property var1);

    public Status removeControllerProperty(String var1);
}

