/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.common.util;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;

public class Rpcs {
    public static <T> RpcResult<T> getRpcResult(boolean successful) {
        RpcResultTO<Object> ret = new RpcResultTO<Object>(successful, null, (Collection<RpcError>)ImmutableList.of());
        return ret;
    }

    public static <T> RpcResult<T> getRpcResult(boolean successful, T result, Collection<RpcError> errors) {
        RpcResultTO<T> ret = new RpcResultTO<T>(successful, result, errors);
        return ret;
    }

    public static <T> RpcResult<T> getRpcResult(boolean successful, Collection<RpcError> errors) {
        return new RpcResultTO<Object>(successful, null, errors);
    }

    private static class RpcResultTO<T>
    implements RpcResult<T>,
    Serializable,
    Immutable {
        private final Collection<RpcError> errors;
        private final T result;
        private final boolean successful;

        public RpcResultTO(boolean successful, T result, Collection<RpcError> errors) {
            this.successful = successful;
            this.result = result;
            this.errors = ImmutableList.copyOf(errors);
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public T getResult() {
            return this.result;
        }

        public Collection<RpcError> getErrors() {
            return this.errors;
        }
    }
}

