/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeaturesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.table.features.TableProperties;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class TableFeaturesBuilder {
    private TableConfig _config;
    private Long _maxEntries;
    private BigInteger _metadataMatch;
    private BigInteger _metadataWrite;
    private String _name;
    private Short _tableId;
    private TableProperties _tableProperties;
    private TableFeaturesKey _key;
    private Map<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>();

    public TableConfig getConfig() {
        return this._config;
    }

    public Long getMaxEntries() {
        return this._maxEntries;
    }

    public BigInteger getMetadataMatch() {
        return this._metadataMatch;
    }

    public BigInteger getMetadataWrite() {
        return this._metadataWrite;
    }

    public String getName() {
        return this._name;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public TableProperties getTableProperties() {
        return this._tableProperties;
    }

    public TableFeaturesKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<TableFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableFeaturesBuilder setConfig(TableConfig value) {
        this._config = value;
        return this;
    }

    public TableFeaturesBuilder setMaxEntries(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxEntries = value;
        return this;
    }

    public TableFeaturesBuilder setMetadataMatch(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._metadataMatch = value;
        return this;
    }

    public TableFeaturesBuilder setMetadataWrite(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._metadataWrite = value;
        return this;
    }

    public TableFeaturesBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TableFeaturesBuilder setTableId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tableId = value;
        return this;
    }

    public TableFeaturesBuilder setTableProperties(TableProperties value) {
        this._tableProperties = value;
        return this;
    }

    public TableFeaturesBuilder setKey(TableFeaturesKey value) {
        this._key = value;
        return this;
    }

    public TableFeaturesBuilder addAugmentation(Class<? extends Augmentation<TableFeatures>> augmentationType, Augmentation<TableFeatures> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableFeatures build() {
        return new TableFeaturesImpl(this);
    }

    private static final class TableFeaturesImpl
    implements TableFeatures {
        private final TableConfig _config;
        private final Long _maxEntries;
        private final BigInteger _metadataMatch;
        private final BigInteger _metadataWrite;
        private final String _name;
        private final Short _tableId;
        private final TableProperties _tableProperties;
        private final TableFeaturesKey _key;
        private Map<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>();

        public Class<TableFeatures> getImplementedInterface() {
            return TableFeatures.class;
        }

        private TableFeaturesImpl(TableFeaturesBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new TableFeaturesKey(builder.getTableId());
                this._tableId = builder.getTableId();
            } else {
                this._key = builder.getKey();
                this._tableId = this._key.getTableId();
            }
            this._config = builder.getConfig();
            this._maxEntries = builder.getMaxEntries();
            this._metadataMatch = builder.getMetadataMatch();
            this._metadataWrite = builder.getMetadataWrite();
            this._name = builder.getName();
            this._tableProperties = builder.getTableProperties();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public TableConfig getConfig() {
            return this._config;
        }

        @Override
        public Long getMaxEntries() {
            return this._maxEntries;
        }

        @Override
        public BigInteger getMetadataMatch() {
            return this._metadataMatch;
        }

        @Override
        public BigInteger getMetadataWrite() {
            return this._metadataWrite;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        @Override
        public TableProperties getTableProperties() {
            return this._tableProperties;
        }

        @Override
        public TableFeaturesKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<TableFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._config == null ? 0 : this._config.hashCode());
            result = 31 * result + (this._maxEntries == null ? 0 : this._maxEntries.hashCode());
            result = 31 * result + (this._metadataMatch == null ? 0 : this._metadataMatch.hashCode());
            result = 31 * result + (this._metadataWrite == null ? 0 : this._metadataWrite.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._tableProperties == null ? 0 : this._tableProperties.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableFeaturesImpl other = (TableFeaturesImpl)obj;
            if (this._config == null ? other._config != null : !this._config.equals(other._config)) {
                return false;
            }
            if (this._maxEntries == null ? other._maxEntries != null : !this._maxEntries.equals(other._maxEntries)) {
                return false;
            }
            if (this._metadataMatch == null ? other._metadataMatch != null : !this._metadataMatch.equals(other._metadataMatch)) {
                return false;
            }
            if (this._metadataWrite == null ? other._metadataWrite != null : !this._metadataWrite.equals(other._metadataWrite)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._tableProperties == null ? other._tableProperties != null : !this._tableProperties.equals(other._tableProperties)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TableFeatures [_config=");
            builder.append(this._config);
            builder.append(", _maxEntries=");
            builder.append(this._maxEntries);
            builder.append(", _metadataMatch=");
            builder.append(this._metadataMatch);
            builder.append(", _metadataWrite=");
            builder.append(this._metadataWrite);
            builder.append(", _name=");
            builder.append(this._name);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _tableProperties=");
            builder.append(this._tableProperties);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

