/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ArpMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpTargetHardwareAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.ArpMatch;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArpMatchBuilder {
    private Integer _arpOp;
    private ArpSourceHardwareAddress _arpSourceHardwareAddress;
    private Ipv4Prefix _arpSourceTransportAddress;
    private ArpTargetHardwareAddress _arpTargetHardwareAddress;
    private Ipv4Prefix _arpTargetTransportAddress;
    private Map<Class<? extends Augmentation<ArpMatch>>, Augmentation<ArpMatch>> augmentation = new HashMap<Class<? extends Augmentation<ArpMatch>>, Augmentation<ArpMatch>>();

    public ArpMatchBuilder() {
    }

    public ArpMatchBuilder(ArpMatchFields arg) {
        this._arpOp = arg.getArpOp();
        this._arpSourceHardwareAddress = arg.getArpSourceHardwareAddress();
        this._arpSourceTransportAddress = arg.getArpSourceTransportAddress();
        this._arpTargetHardwareAddress = arg.getArpTargetHardwareAddress();
        this._arpTargetTransportAddress = arg.getArpTargetTransportAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ArpMatchFields) {
            this._arpOp = ((ArpMatchFields)arg).getArpOp();
            this._arpSourceHardwareAddress = ((ArpMatchFields)arg).getArpSourceHardwareAddress();
            this._arpSourceTransportAddress = ((ArpMatchFields)arg).getArpSourceTransportAddress();
            this._arpTargetHardwareAddress = ((ArpMatchFields)arg).getArpTargetHardwareAddress();
            this._arpTargetTransportAddress = ((ArpMatchFields)arg).getArpTargetTransportAddress();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ArpMatchFields] \nbut was: " + arg);
        }
    }

    public Integer getArpOp() {
        return this._arpOp;
    }

    public ArpSourceHardwareAddress getArpSourceHardwareAddress() {
        return this._arpSourceHardwareAddress;
    }

    public Ipv4Prefix getArpSourceTransportAddress() {
        return this._arpSourceTransportAddress;
    }

    public ArpTargetHardwareAddress getArpTargetHardwareAddress() {
        return this._arpTargetHardwareAddress;
    }

    public Ipv4Prefix getArpTargetTransportAddress() {
        return this._arpTargetTransportAddress;
    }

    public <E extends Augmentation<ArpMatch>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ArpMatchBuilder setArpOp(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._arpOp = value;
        return this;
    }

    public ArpMatchBuilder setArpSourceHardwareAddress(ArpSourceHardwareAddress value) {
        this._arpSourceHardwareAddress = value;
        return this;
    }

    public ArpMatchBuilder setArpSourceTransportAddress(Ipv4Prefix value) {
        this._arpSourceTransportAddress = value;
        return this;
    }

    public ArpMatchBuilder setArpTargetHardwareAddress(ArpTargetHardwareAddress value) {
        this._arpTargetHardwareAddress = value;
        return this;
    }

    public ArpMatchBuilder setArpTargetTransportAddress(Ipv4Prefix value) {
        this._arpTargetTransportAddress = value;
        return this;
    }

    public ArpMatchBuilder addAugmentation(Class<? extends Augmentation<ArpMatch>> augmentationType, Augmentation<ArpMatch> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArpMatch build() {
        return new ArpMatchImpl(this);
    }

    private static final class ArpMatchImpl
    implements ArpMatch {
        private final Integer _arpOp;
        private final ArpSourceHardwareAddress _arpSourceHardwareAddress;
        private final Ipv4Prefix _arpSourceTransportAddress;
        private final ArpTargetHardwareAddress _arpTargetHardwareAddress;
        private final Ipv4Prefix _arpTargetTransportAddress;
        private Map<Class<? extends Augmentation<ArpMatch>>, Augmentation<ArpMatch>> augmentation = new HashMap<Class<? extends Augmentation<ArpMatch>>, Augmentation<ArpMatch>>();

        public Class<ArpMatch> getImplementedInterface() {
            return ArpMatch.class;
        }

        private ArpMatchImpl(ArpMatchBuilder builder) {
            this._arpOp = builder.getArpOp();
            this._arpSourceHardwareAddress = builder.getArpSourceHardwareAddress();
            this._arpSourceTransportAddress = builder.getArpSourceTransportAddress();
            this._arpTargetHardwareAddress = builder.getArpTargetHardwareAddress();
            this._arpTargetTransportAddress = builder.getArpTargetTransportAddress();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getArpOp() {
            return this._arpOp;
        }

        @Override
        public ArpSourceHardwareAddress getArpSourceHardwareAddress() {
            return this._arpSourceHardwareAddress;
        }

        @Override
        public Ipv4Prefix getArpSourceTransportAddress() {
            return this._arpSourceTransportAddress;
        }

        @Override
        public ArpTargetHardwareAddress getArpTargetHardwareAddress() {
            return this._arpTargetHardwareAddress;
        }

        @Override
        public Ipv4Prefix getArpTargetTransportAddress() {
            return this._arpTargetTransportAddress;
        }

        public <E extends Augmentation<ArpMatch>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._arpOp == null ? 0 : this._arpOp.hashCode());
            result = 31 * result + (this._arpSourceHardwareAddress == null ? 0 : this._arpSourceHardwareAddress.hashCode());
            result = 31 * result + (this._arpSourceTransportAddress == null ? 0 : this._arpSourceTransportAddress.hashCode());
            result = 31 * result + (this._arpTargetHardwareAddress == null ? 0 : this._arpTargetHardwareAddress.hashCode());
            result = 31 * result + (this._arpTargetTransportAddress == null ? 0 : this._arpTargetTransportAddress.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArpMatchImpl other = (ArpMatchImpl)obj;
            if (this._arpOp == null ? other._arpOp != null : !this._arpOp.equals(other._arpOp)) {
                return false;
            }
            if (this._arpSourceHardwareAddress == null ? other._arpSourceHardwareAddress != null : !this._arpSourceHardwareAddress.equals(other._arpSourceHardwareAddress)) {
                return false;
            }
            if (this._arpSourceTransportAddress == null ? other._arpSourceTransportAddress != null : !this._arpSourceTransportAddress.equals((Object)other._arpSourceTransportAddress)) {
                return false;
            }
            if (this._arpTargetHardwareAddress == null ? other._arpTargetHardwareAddress != null : !this._arpTargetHardwareAddress.equals(other._arpTargetHardwareAddress)) {
                return false;
            }
            if (this._arpTargetTransportAddress == null ? other._arpTargetTransportAddress != null : !this._arpTargetTransportAddress.equals((Object)other._arpTargetTransportAddress)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ArpMatch [_arpOp=");
            builder.append(this._arpOp);
            builder.append(", _arpSourceHardwareAddress=");
            builder.append(this._arpSourceHardwareAddress);
            builder.append(", _arpSourceTransportAddress=");
            builder.append(this._arpSourceTransportAddress);
            builder.append(", _arpTargetHardwareAddress=");
            builder.append(this._arpTargetHardwareAddress);
            builder.append(", _arpTargetTransportAddress=");
            builder.append(this._arpTargetTransportAddress);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

