/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.VlanMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.vlan.match.fields.VlanId;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VlanMatchBuilder {
    private VlanId _vlanId;
    private VlanPcp _vlanPcp;
    private Map<Class<? extends Augmentation<VlanMatch>>, Augmentation<VlanMatch>> augmentation = new HashMap<Class<? extends Augmentation<VlanMatch>>, Augmentation<VlanMatch>>();

    public VlanMatchBuilder() {
    }

    public VlanMatchBuilder(VlanMatchFields arg) {
        this._vlanId = arg.getVlanId();
        this._vlanPcp = arg.getVlanPcp();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanMatchFields) {
            this._vlanId = ((VlanMatchFields)arg).getVlanId();
            this._vlanPcp = ((VlanMatchFields)arg).getVlanPcp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.VlanMatchFields] \nbut was: " + arg);
        }
    }

    public VlanId getVlanId() {
        return this._vlanId;
    }

    public VlanPcp getVlanPcp() {
        return this._vlanPcp;
    }

    public <E extends Augmentation<VlanMatch>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VlanMatchBuilder setVlanId(VlanId value) {
        this._vlanId = value;
        return this;
    }

    public VlanMatchBuilder setVlanPcp(VlanPcp value) {
        this._vlanPcp = value;
        return this;
    }

    public VlanMatchBuilder addAugmentation(Class<? extends Augmentation<VlanMatch>> augmentationType, Augmentation<VlanMatch> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VlanMatch build() {
        return new VlanMatchImpl(this);
    }

    private static final class VlanMatchImpl
    implements VlanMatch {
        private final VlanId _vlanId;
        private final VlanPcp _vlanPcp;
        private Map<Class<? extends Augmentation<VlanMatch>>, Augmentation<VlanMatch>> augmentation = new HashMap<Class<? extends Augmentation<VlanMatch>>, Augmentation<VlanMatch>>();

        public Class<VlanMatch> getImplementedInterface() {
            return VlanMatch.class;
        }

        private VlanMatchImpl(VlanMatchBuilder builder) {
            this._vlanId = builder.getVlanId();
            this._vlanPcp = builder.getVlanPcp();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public VlanId getVlanId() {
            return this._vlanId;
        }

        @Override
        public VlanPcp getVlanPcp() {
            return this._vlanPcp;
        }

        public <E extends Augmentation<VlanMatch>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._vlanId == null ? 0 : this._vlanId.hashCode());
            result = 31 * result + (this._vlanPcp == null ? 0 : this._vlanPcp.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VlanMatchImpl other = (VlanMatchImpl)obj;
            if (this._vlanId == null ? other._vlanId != null : !this._vlanId.equals(other._vlanId)) {
                return false;
            }
            if (this._vlanPcp == null ? other._vlanPcp != null : !this._vlanPcp.equals((Object)other._vlanPcp)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VlanMatch [_vlanId=");
            builder.append(this._vlanId);
            builder.append(", _vlanPcp=");
            builder.append(this._vlanPcp);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

