/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Tunnel;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class TunnelBuilder {
    private BigInteger _tunnelId;
    private BigInteger _tunnelMask;
    private Map<Class<? extends Augmentation<Tunnel>>, Augmentation<Tunnel>> augmentation = new HashMap<Class<? extends Augmentation<Tunnel>>, Augmentation<Tunnel>>();

    public BigInteger getTunnelId() {
        return this._tunnelId;
    }

    public BigInteger getTunnelMask() {
        return this._tunnelMask;
    }

    public <E extends Augmentation<Tunnel>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TunnelBuilder setTunnelId(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tunnelId = value;
        return this;
    }

    public TunnelBuilder setTunnelMask(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tunnelMask = value;
        return this;
    }

    public TunnelBuilder addAugmentation(Class<? extends Augmentation<Tunnel>> augmentationType, Augmentation<Tunnel> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Tunnel build() {
        return new TunnelImpl(this);
    }

    private static final class TunnelImpl
    implements Tunnel {
        private final BigInteger _tunnelId;
        private final BigInteger _tunnelMask;
        private Map<Class<? extends Augmentation<Tunnel>>, Augmentation<Tunnel>> augmentation = new HashMap<Class<? extends Augmentation<Tunnel>>, Augmentation<Tunnel>>();

        public Class<Tunnel> getImplementedInterface() {
            return Tunnel.class;
        }

        private TunnelImpl(TunnelBuilder builder) {
            this._tunnelId = builder.getTunnelId();
            this._tunnelMask = builder.getTunnelMask();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getTunnelId() {
            return this._tunnelId;
        }

        @Override
        public BigInteger getTunnelMask() {
            return this._tunnelMask;
        }

        public <E extends Augmentation<Tunnel>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._tunnelId == null ? 0 : this._tunnelId.hashCode());
            result = 31 * result + (this._tunnelMask == null ? 0 : this._tunnelMask.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TunnelImpl other = (TunnelImpl)obj;
            if (this._tunnelId == null ? other._tunnelId != null : !this._tunnelId.equals(other._tunnelId)) {
                return false;
            }
            if (this._tunnelMask == null ? other._tunnelMask != null : !this._tunnelMask.equals(other._tunnelMask)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Tunnel [_tunnelId=");
            builder.append(this._tunnelId);
            builder.append(", _tunnelMask=");
            builder.append(this._tunnelMask);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

