/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.OfMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Metadata;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetadataBuilder {
    private BigInteger _metadata;
    private BigInteger _metadataMask;
    private Map<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>> augmentation = new HashMap<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>>();

    public MetadataBuilder() {
    }

    public MetadataBuilder(OfMetadata arg) {
        this._metadata = arg.getMetadata();
        this._metadataMask = arg.getMetadataMask();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfMetadata) {
            this._metadata = ((OfMetadata)arg).getMetadata();
            this._metadataMask = ((OfMetadata)arg).getMetadataMask();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.OfMetadata] \nbut was: " + arg);
        }
    }

    public BigInteger getMetadata() {
        return this._metadata;
    }

    public BigInteger getMetadataMask() {
        return this._metadataMask;
    }

    public <E extends Augmentation<Metadata>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MetadataBuilder setMetadata(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._metadata = value;
        return this;
    }

    public MetadataBuilder setMetadataMask(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._metadataMask = value;
        return this;
    }

    public MetadataBuilder addAugmentation(Class<? extends Augmentation<Metadata>> augmentationType, Augmentation<Metadata> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Metadata build() {
        return new MetadataImpl(this);
    }

    private static final class MetadataImpl
    implements Metadata {
        private final BigInteger _metadata;
        private final BigInteger _metadataMask;
        private Map<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>> augmentation = new HashMap<Class<? extends Augmentation<Metadata>>, Augmentation<Metadata>>();

        public Class<Metadata> getImplementedInterface() {
            return Metadata.class;
        }

        private MetadataImpl(MetadataBuilder builder) {
            this._metadata = builder.getMetadata();
            this._metadataMask = builder.getMetadataMask();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getMetadata() {
            return this._metadata;
        }

        @Override
        public BigInteger getMetadataMask() {
            return this._metadataMask;
        }

        public <E extends Augmentation<Metadata>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._metadata == null ? 0 : this._metadata.hashCode());
            result = 31 * result + (this._metadataMask == null ? 0 : this._metadataMask.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetadataImpl other = (MetadataImpl)obj;
            if (this._metadata == null ? other._metadata != null : !this._metadata.equals(other._metadata)) {
                return false;
            }
            if (this._metadataMask == null ? other._metadataMask != null : !this._metadataMask.equals(other._metadataMask)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Metadata [_metadata=");
            builder.append(this._metadata);
            builder.append(", _metadataMask=");
            builder.append(this._metadataMask);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

