/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.IpMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpMatchBuilder {
    private Dscp _ipDscp;
    private Short _ipEcn;
    private IpVersion _ipProto;
    private Short _ipProtocol;
    private Map<Class<? extends Augmentation<IpMatch>>, Augmentation<IpMatch>> augmentation = new HashMap<Class<? extends Augmentation<IpMatch>>, Augmentation<IpMatch>>();

    public IpMatchBuilder() {
    }

    public IpMatchBuilder(IpMatchFields arg) {
        this._ipDscp = arg.getIpDscp();
        this._ipEcn = arg.getIpEcn();
        this._ipProto = arg.getIpProto();
        this._ipProtocol = arg.getIpProtocol();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IpMatchFields) {
            this._ipDscp = ((IpMatchFields)arg).getIpDscp();
            this._ipEcn = ((IpMatchFields)arg).getIpEcn();
            this._ipProto = ((IpMatchFields)arg).getIpProto();
            this._ipProtocol = ((IpMatchFields)arg).getIpProtocol();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.IpMatchFields] \nbut was: " + arg);
        }
    }

    public Dscp getIpDscp() {
        return this._ipDscp;
    }

    public Short getIpEcn() {
        return this._ipEcn;
    }

    public IpVersion getIpProto() {
        return this._ipProto;
    }

    public Short getIpProtocol() {
        return this._ipProtocol;
    }

    public <E extends Augmentation<IpMatch>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IpMatchBuilder setIpDscp(Dscp value) {
        this._ipDscp = value;
        return this;
    }

    public IpMatchBuilder setIpEcn(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ipEcn = value;
        return this;
    }

    public IpMatchBuilder setIpProto(IpVersion value) {
        this._ipProto = value;
        return this;
    }

    public IpMatchBuilder setIpProtocol(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ipProtocol = value;
        return this;
    }

    public IpMatchBuilder addAugmentation(Class<? extends Augmentation<IpMatch>> augmentationType, Augmentation<IpMatch> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public IpMatch build() {
        return new IpMatchImpl(this);
    }

    private static final class IpMatchImpl
    implements IpMatch {
        private final Dscp _ipDscp;
        private final Short _ipEcn;
        private final IpVersion _ipProto;
        private final Short _ipProtocol;
        private Map<Class<? extends Augmentation<IpMatch>>, Augmentation<IpMatch>> augmentation = new HashMap<Class<? extends Augmentation<IpMatch>>, Augmentation<IpMatch>>();

        public Class<IpMatch> getImplementedInterface() {
            return IpMatch.class;
        }

        private IpMatchImpl(IpMatchBuilder builder) {
            this._ipDscp = builder.getIpDscp();
            this._ipEcn = builder.getIpEcn();
            this._ipProto = builder.getIpProto();
            this._ipProtocol = builder.getIpProtocol();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Dscp getIpDscp() {
            return this._ipDscp;
        }

        @Override
        public Short getIpEcn() {
            return this._ipEcn;
        }

        @Override
        public IpVersion getIpProto() {
            return this._ipProto;
        }

        @Override
        public Short getIpProtocol() {
            return this._ipProtocol;
        }

        public <E extends Augmentation<IpMatch>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipDscp == null ? 0 : this._ipDscp.hashCode());
            result = 31 * result + (this._ipEcn == null ? 0 : this._ipEcn.hashCode());
            result = 31 * result + (this._ipProto == null ? 0 : this._ipProto.hashCode());
            result = 31 * result + (this._ipProtocol == null ? 0 : this._ipProtocol.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IpMatchImpl other = (IpMatchImpl)obj;
            if (this._ipDscp == null ? other._ipDscp != null : !this._ipDscp.equals((Object)other._ipDscp)) {
                return false;
            }
            if (this._ipEcn == null ? other._ipEcn != null : !this._ipEcn.equals(other._ipEcn)) {
                return false;
            }
            if (this._ipProto == null ? other._ipProto != null : !this._ipProto.equals((Object)other._ipProto)) {
                return false;
            }
            if (this._ipProtocol == null ? other._ipProtocol != null : !this._ipProtocol.equals(other._ipProtocol)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IpMatch [_ipDscp=");
            builder.append(this._ipDscp);
            builder.append(", _ipEcn=");
            builder.append(this._ipEcn);
            builder.append(", _ipProto=");
            builder.append(this._ipProto);
            builder.append(", _ipProtocol=");
            builder.append(this._ipProtocol);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

