/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.ipv6.match.fields.Ipv6ExtHeader;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class Ipv6ExtHeaderBuilder {
    private Integer _ipv6Exthdr;
    private Integer _ipv6ExthdrMask;
    private Map<Class<? extends Augmentation<Ipv6ExtHeader>>, Augmentation<Ipv6ExtHeader>> augmentation = new HashMap<Class<? extends Augmentation<Ipv6ExtHeader>>, Augmentation<Ipv6ExtHeader>>();

    public Integer getIpv6Exthdr() {
        return this._ipv6Exthdr;
    }

    public Integer getIpv6ExthdrMask() {
        return this._ipv6ExthdrMask;
    }

    public <E extends Augmentation<Ipv6ExtHeader>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6ExtHeaderBuilder setIpv6Exthdr(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ipv6Exthdr = value;
        return this;
    }

    public Ipv6ExtHeaderBuilder setIpv6ExthdrMask(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("512")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ipv6ExthdrMask = value;
        return this;
    }

    public Ipv6ExtHeaderBuilder addAugmentation(Class<? extends Augmentation<Ipv6ExtHeader>> augmentationType, Augmentation<Ipv6ExtHeader> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv6ExtHeader build() {
        return new Ipv6ExtHeaderImpl(this);
    }

    private static final class Ipv6ExtHeaderImpl
    implements Ipv6ExtHeader {
        private final Integer _ipv6Exthdr;
        private final Integer _ipv6ExthdrMask;
        private Map<Class<? extends Augmentation<Ipv6ExtHeader>>, Augmentation<Ipv6ExtHeader>> augmentation = new HashMap<Class<? extends Augmentation<Ipv6ExtHeader>>, Augmentation<Ipv6ExtHeader>>();

        public Class<Ipv6ExtHeader> getImplementedInterface() {
            return Ipv6ExtHeader.class;
        }

        private Ipv6ExtHeaderImpl(Ipv6ExtHeaderBuilder builder) {
            this._ipv6Exthdr = builder.getIpv6Exthdr();
            this._ipv6ExthdrMask = builder.getIpv6ExthdrMask();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getIpv6Exthdr() {
            return this._ipv6Exthdr;
        }

        @Override
        public Integer getIpv6ExthdrMask() {
            return this._ipv6ExthdrMask;
        }

        public <E extends Augmentation<Ipv6ExtHeader>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipv6Exthdr == null ? 0 : this._ipv6Exthdr.hashCode());
            result = 31 * result + (this._ipv6ExthdrMask == null ? 0 : this._ipv6ExthdrMask.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ipv6ExtHeaderImpl other = (Ipv6ExtHeaderImpl)obj;
            if (this._ipv6Exthdr == null ? other._ipv6Exthdr != null : !this._ipv6Exthdr.equals(other._ipv6Exthdr)) {
                return false;
            }
            if (this._ipv6ExthdrMask == null ? other._ipv6ExthdrMask != null : !this._ipv6ExthdrMask.equals(other._ipv6ExthdrMask)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Ipv6ExtHeader [_ipv6Exthdr=");
            builder.append(this._ipv6Exthdr);
            builder.append(", _ipv6ExthdrMask=");
            builder.append(this._ipv6ExthdrMask);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

