/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.MacAddressFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.arp.match.fields.ArpSourceHardwareAddress;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArpSourceHardwareAddressBuilder {
    private MacAddress _address;
    private MacAddress _mask;
    private Map<Class<? extends Augmentation<ArpSourceHardwareAddress>>, Augmentation<ArpSourceHardwareAddress>> augmentation = new HashMap<Class<? extends Augmentation<ArpSourceHardwareAddress>>, Augmentation<ArpSourceHardwareAddress>>();

    public ArpSourceHardwareAddressBuilder() {
    }

    public ArpSourceHardwareAddressBuilder(MacAddressFilter arg) {
        this._address = arg.getAddress();
        this._mask = arg.getMask();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MacAddressFilter) {
            this._address = ((MacAddressFilter)arg).getAddress();
            this._mask = ((MacAddressFilter)arg).getMask();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.MacAddressFilter] \nbut was: " + arg);
        }
    }

    public MacAddress getAddress() {
        return this._address;
    }

    public MacAddress getMask() {
        return this._mask;
    }

    public <E extends Augmentation<ArpSourceHardwareAddress>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ArpSourceHardwareAddressBuilder setAddress(MacAddress value) {
        this._address = value;
        return this;
    }

    public ArpSourceHardwareAddressBuilder setMask(MacAddress value) {
        this._mask = value;
        return this;
    }

    public ArpSourceHardwareAddressBuilder addAugmentation(Class<? extends Augmentation<ArpSourceHardwareAddress>> augmentationType, Augmentation<ArpSourceHardwareAddress> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArpSourceHardwareAddress build() {
        return new ArpSourceHardwareAddressImpl(this);
    }

    private static final class ArpSourceHardwareAddressImpl
    implements ArpSourceHardwareAddress {
        private final MacAddress _address;
        private final MacAddress _mask;
        private Map<Class<? extends Augmentation<ArpSourceHardwareAddress>>, Augmentation<ArpSourceHardwareAddress>> augmentation = new HashMap<Class<? extends Augmentation<ArpSourceHardwareAddress>>, Augmentation<ArpSourceHardwareAddress>>();

        public Class<ArpSourceHardwareAddress> getImplementedInterface() {
            return ArpSourceHardwareAddress.class;
        }

        private ArpSourceHardwareAddressImpl(ArpSourceHardwareAddressBuilder builder) {
            this._address = builder.getAddress();
            this._mask = builder.getMask();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MacAddress getAddress() {
            return this._address;
        }

        @Override
        public MacAddress getMask() {
            return this._mask;
        }

        public <E extends Augmentation<ArpSourceHardwareAddress>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
            result = 31 * result + (this._mask == null ? 0 : this._mask.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArpSourceHardwareAddressImpl other = (ArpSourceHardwareAddressImpl)obj;
            if (this._address == null ? other._address != null : !this._address.equals((Object)other._address)) {
                return false;
            }
            if (this._mask == null ? other._mask != null : !this._mask.equals((Object)other._mask)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ArpSourceHardwareAddress [_address=");
            builder.append(this._address);
            builder.append(", _mask=");
            builder.append(this._mask);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

