/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.stats.config.request;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.stats.config.request.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.stats.config.request.MeterStatsKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MeterStatsBuilder {
    private MeterId _meterId;
    private MeterStatsKey _key;
    private Map<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>();

    public MeterId getMeterId() {
        return this._meterId;
    }

    public MeterStatsKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<MeterStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterStatsBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterStatsBuilder setKey(MeterStatsKey value) {
        this._key = value;
        return this;
    }

    public MeterStatsBuilder addAugmentation(Class<? extends Augmentation<MeterStats>> augmentationType, Augmentation<MeterStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterStats build() {
        return new MeterStatsImpl(this);
    }

    private static final class MeterStatsImpl
    implements MeterStats {
        private final MeterId _meterId;
        private final MeterStatsKey _key;
        private Map<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>();

        public Class<MeterStats> getImplementedInterface() {
            return MeterStats.class;
        }

        private MeterStatsImpl(MeterStatsBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new MeterStatsKey(builder.getMeterId());
                this._meterId = builder.getMeterId();
            } else {
                this._key = builder.getKey();
                this._meterId = this._key.getMeterId();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        @Override
        public MeterStatsKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<MeterStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterStatsImpl other = (MeterStatsImpl)obj;
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals(other._meterId)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterStats [_meterId=");
            builder.append(this._meterId);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

