/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.meter.band.stats;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.BandId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.meter.band.stats.BandStat;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.meter.band.stats.BandStatKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BandStatBuilder {
    private BandId _bandId;
    private Counter64 _byteBandCount;
    private Counter64 _packetBandCount;
    private BandStatKey _key;
    private Map<Class<? extends Augmentation<BandStat>>, Augmentation<BandStat>> augmentation = new HashMap<Class<? extends Augmentation<BandStat>>, Augmentation<BandStat>>();

    public BandId getBandId() {
        return this._bandId;
    }

    public Counter64 getByteBandCount() {
        return this._byteBandCount;
    }

    public Counter64 getPacketBandCount() {
        return this._packetBandCount;
    }

    public BandStatKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BandStat>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BandStatBuilder setBandId(BandId value) {
        this._bandId = value;
        return this;
    }

    public BandStatBuilder setByteBandCount(Counter64 value) {
        this._byteBandCount = value;
        return this;
    }

    public BandStatBuilder setPacketBandCount(Counter64 value) {
        this._packetBandCount = value;
        return this;
    }

    public BandStatBuilder setKey(BandStatKey value) {
        this._key = value;
        return this;
    }

    public BandStatBuilder addAugmentation(Class<? extends Augmentation<BandStat>> augmentationType, Augmentation<BandStat> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BandStat build() {
        return new BandStatImpl(this);
    }

    private static final class BandStatImpl
    implements BandStat {
        private final BandId _bandId;
        private final Counter64 _byteBandCount;
        private final Counter64 _packetBandCount;
        private final BandStatKey _key;
        private Map<Class<? extends Augmentation<BandStat>>, Augmentation<BandStat>> augmentation = new HashMap<Class<? extends Augmentation<BandStat>>, Augmentation<BandStat>>();

        public Class<BandStat> getImplementedInterface() {
            return BandStat.class;
        }

        private BandStatImpl(BandStatBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new BandStatKey(builder.getBandId());
                this._bandId = builder.getBandId();
            } else {
                this._key = builder.getKey();
                this._bandId = this._key.getBandId();
            }
            this._byteBandCount = builder.getByteBandCount();
            this._packetBandCount = builder.getPacketBandCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BandId getBandId() {
            return this._bandId;
        }

        @Override
        public Counter64 getByteBandCount() {
            return this._byteBandCount;
        }

        @Override
        public Counter64 getPacketBandCount() {
            return this._packetBandCount;
        }

        @Override
        public BandStatKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BandStat>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bandId == null ? 0 : this._bandId.hashCode());
            result = 31 * result + (this._byteBandCount == null ? 0 : this._byteBandCount.hashCode());
            result = 31 * result + (this._packetBandCount == null ? 0 : this._packetBandCount.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BandStatImpl other = (BandStatImpl)obj;
            if (this._bandId == null ? other._bandId != null : !this._bandId.equals(other._bandId)) {
                return false;
            }
            if (this._byteBandCount == null ? other._byteBandCount != null : !this._byteBandCount.equals((Object)other._byteBandCount)) {
                return false;
            }
            if (this._packetBandCount == null ? other._packetBandCount != null : !this._packetBandCount.equals((Object)other._packetBandCount)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BandStat [_bandId=");
            builder.append(this._bandId);
            builder.append(", _byteBandCount=");
            builder.append(this._byteBandCount);
            builder.append(", _packetBandCount=");
            builder.append(this._packetBandCount);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

