/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.meter.band.headers;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.BandId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.BandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.meter.band.headers.MeterBandHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.meter.band.headers.MeterBandHeaderKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.meter.band.headers.meter.band.header.MeterBandTypes;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterBandHeaderBuilder {
    private Long _bandBurstSize;
    private BandId _bandId;
    private Long _bandRate;
    private MeterBandTypes _meterBandTypes;
    private MeterBandHeaderKey _key;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.BandType _bandType;
    private Map<Class<? extends Augmentation<MeterBandHeader>>, Augmentation<MeterBandHeader>> augmentation = new HashMap<Class<? extends Augmentation<MeterBandHeader>>, Augmentation<MeterBandHeader>>();

    public MeterBandHeaderBuilder() {
    }

    public MeterBandHeaderBuilder(BandType arg) {
        this._bandType = arg.getBandType();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BandType) {
            this._bandType = ((BandType)arg).getBandType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.BandType] \nbut was: " + arg);
        }
    }

    public Long getBandBurstSize() {
        return this._bandBurstSize;
    }

    public BandId getBandId() {
        return this._bandId;
    }

    public Long getBandRate() {
        return this._bandRate;
    }

    public MeterBandTypes getMeterBandTypes() {
        return this._meterBandTypes;
    }

    public MeterBandHeaderKey getKey() {
        return this._key;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.BandType getBandType() {
        return this._bandType;
    }

    public <E extends Augmentation<MeterBandHeader>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterBandHeaderBuilder setBandBurstSize(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._bandBurstSize = value;
        return this;
    }

    public MeterBandHeaderBuilder setBandId(BandId value) {
        this._bandId = value;
        return this;
    }

    public MeterBandHeaderBuilder setBandRate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._bandRate = value;
        return this;
    }

    public MeterBandHeaderBuilder setMeterBandTypes(MeterBandTypes value) {
        this._meterBandTypes = value;
        return this;
    }

    public MeterBandHeaderBuilder setKey(MeterBandHeaderKey value) {
        this._key = value;
        return this;
    }

    public MeterBandHeaderBuilder setBandType(org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.BandType value) {
        this._bandType = value;
        return this;
    }

    public MeterBandHeaderBuilder addAugmentation(Class<? extends Augmentation<MeterBandHeader>> augmentationType, Augmentation<MeterBandHeader> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterBandHeader build() {
        return new MeterBandHeaderImpl(this);
    }

    private static final class MeterBandHeaderImpl
    implements MeterBandHeader {
        private final Long _bandBurstSize;
        private final BandId _bandId;
        private final Long _bandRate;
        private final MeterBandTypes _meterBandTypes;
        private final MeterBandHeaderKey _key;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.BandType _bandType;
        private Map<Class<? extends Augmentation<MeterBandHeader>>, Augmentation<MeterBandHeader>> augmentation = new HashMap<Class<? extends Augmentation<MeterBandHeader>>, Augmentation<MeterBandHeader>>();

        public Class<MeterBandHeader> getImplementedInterface() {
            return MeterBandHeader.class;
        }

        private MeterBandHeaderImpl(MeterBandHeaderBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new MeterBandHeaderKey(builder.getBandId());
                this._bandId = builder.getBandId();
            } else {
                this._key = builder.getKey();
                this._bandId = this._key.getBandId();
            }
            this._bandBurstSize = builder.getBandBurstSize();
            this._bandRate = builder.getBandRate();
            this._meterBandTypes = builder.getMeterBandTypes();
            this._bandType = builder.getBandType();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getBandBurstSize() {
            return this._bandBurstSize;
        }

        @Override
        public BandId getBandId() {
            return this._bandId;
        }

        @Override
        public Long getBandRate() {
            return this._bandRate;
        }

        @Override
        public MeterBandTypes getMeterBandTypes() {
            return this._meterBandTypes;
        }

        @Override
        public MeterBandHeaderKey getKey() {
            return this._key;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.BandType getBandType() {
            return this._bandType;
        }

        public <E extends Augmentation<MeterBandHeader>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bandBurstSize == null ? 0 : this._bandBurstSize.hashCode());
            result = 31 * result + (this._bandId == null ? 0 : this._bandId.hashCode());
            result = 31 * result + (this._bandRate == null ? 0 : this._bandRate.hashCode());
            result = 31 * result + (this._meterBandTypes == null ? 0 : this._meterBandTypes.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._bandType == null ? 0 : this._bandType.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterBandHeaderImpl other = (MeterBandHeaderImpl)obj;
            if (this._bandBurstSize == null ? other._bandBurstSize != null : !this._bandBurstSize.equals(other._bandBurstSize)) {
                return false;
            }
            if (this._bandId == null ? other._bandId != null : !this._bandId.equals(other._bandId)) {
                return false;
            }
            if (this._bandRate == null ? other._bandRate != null : !this._bandRate.equals(other._bandRate)) {
                return false;
            }
            if (this._meterBandTypes == null ? other._meterBandTypes != null : !this._meterBandTypes.equals(other._meterBandTypes)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._bandType == null ? other._bandType != null : !this._bandType.equals(other._bandType)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterBandHeader [_bandBurstSize=");
            builder.append(this._bandBurstSize);
            builder.append(", _bandId=");
            builder.append(this._bandId);
            builder.append(", _bandRate=");
            builder.append(this._bandRate);
            builder.append(", _meterBandTypes=");
            builder.append(this._meterBandTypes);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _bandType=");
            builder.append(this._bandType);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

