/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type.Experimenter;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ExperimenterBuilder {
    private Long _experimenter;
    private Long _experimenterBurstSize;
    private Long _experimenterRate;
    private Map<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>> augmentation = new HashMap<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>>();

    public Long getExperimenter() {
        return this._experimenter;
    }

    public Long getExperimenterBurstSize() {
        return this._experimenterBurstSize;
    }

    public Long getExperimenterRate() {
        return this._experimenterRate;
    }

    public <E extends Augmentation<Experimenter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ExperimenterBuilder setExperimenter(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._experimenter = value;
        return this;
    }

    public ExperimenterBuilder setExperimenterBurstSize(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._experimenterBurstSize = value;
        return this;
    }

    public ExperimenterBuilder setExperimenterRate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._experimenterRate = value;
        return this;
    }

    public ExperimenterBuilder addAugmentation(Class<? extends Augmentation<Experimenter>> augmentationType, Augmentation<Experimenter> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Experimenter build() {
        return new ExperimenterImpl(this);
    }

    private static final class ExperimenterImpl
    implements Experimenter {
        private final Long _experimenter;
        private final Long _experimenterBurstSize;
        private final Long _experimenterRate;
        private Map<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>> augmentation = new HashMap<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>>();

        public Class<Experimenter> getImplementedInterface() {
            return Experimenter.class;
        }

        private ExperimenterImpl(ExperimenterBuilder builder) {
            this._experimenter = builder.getExperimenter();
            this._experimenterBurstSize = builder.getExperimenterBurstSize();
            this._experimenterRate = builder.getExperimenterRate();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getExperimenter() {
            return this._experimenter;
        }

        @Override
        public Long getExperimenterBurstSize() {
            return this._experimenterBurstSize;
        }

        @Override
        public Long getExperimenterRate() {
            return this._experimenterRate;
        }

        public <E extends Augmentation<Experimenter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._experimenter == null ? 0 : this._experimenter.hashCode());
            result = 31 * result + (this._experimenterBurstSize == null ? 0 : this._experimenterBurstSize.hashCode());
            result = 31 * result + (this._experimenterRate == null ? 0 : this._experimenterRate.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExperimenterImpl other = (ExperimenterImpl)obj;
            if (this._experimenter == null ? other._experimenter != null : !this._experimenter.equals(other._experimenter)) {
                return false;
            }
            if (this._experimenterBurstSize == null ? other._experimenterBurstSize != null : !this._experimenterBurstSize.equals(other._experimenterBurstSize)) {
                return false;
            }
            if (this._experimenterRate == null ? other._experimenterRate != null : !this._experimenterRate.equals(other._experimenterRate)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Experimenter [_experimenter=");
            builder.append(this._experimenter);
            builder.append(", _experimenterBurstSize=");
            builder.append(this._experimenterBurstSize);
            builder.append(", _experimenterRate=");
            builder.append(this._experimenterRate);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

