/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type.DscpRemark;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class DscpRemarkBuilder {
    private Long _dscpRemarkBurstSize;
    private Long _dscpRemarkRate;
    private Short _percLevel;
    private Map<Class<? extends Augmentation<DscpRemark>>, Augmentation<DscpRemark>> augmentation = new HashMap<Class<? extends Augmentation<DscpRemark>>, Augmentation<DscpRemark>>();

    public Long getDscpRemarkBurstSize() {
        return this._dscpRemarkBurstSize;
    }

    public Long getDscpRemarkRate() {
        return this._dscpRemarkRate;
    }

    public Short getPercLevel() {
        return this._percLevel;
    }

    public <E extends Augmentation<DscpRemark>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DscpRemarkBuilder setDscpRemarkBurstSize(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dscpRemarkBurstSize = value;
        return this;
    }

    public DscpRemarkBuilder setDscpRemarkRate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dscpRemarkRate = value;
        return this;
    }

    public DscpRemarkBuilder setPercLevel(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._percLevel = value;
        return this;
    }

    public DscpRemarkBuilder addAugmentation(Class<? extends Augmentation<DscpRemark>> augmentationType, Augmentation<DscpRemark> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public DscpRemark build() {
        return new DscpRemarkImpl(this);
    }

    private static final class DscpRemarkImpl
    implements DscpRemark {
        private final Long _dscpRemarkBurstSize;
        private final Long _dscpRemarkRate;
        private final Short _percLevel;
        private Map<Class<? extends Augmentation<DscpRemark>>, Augmentation<DscpRemark>> augmentation = new HashMap<Class<? extends Augmentation<DscpRemark>>, Augmentation<DscpRemark>>();

        public Class<DscpRemark> getImplementedInterface() {
            return DscpRemark.class;
        }

        private DscpRemarkImpl(DscpRemarkBuilder builder) {
            this._dscpRemarkBurstSize = builder.getDscpRemarkBurstSize();
            this._dscpRemarkRate = builder.getDscpRemarkRate();
            this._percLevel = builder.getPercLevel();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getDscpRemarkBurstSize() {
            return this._dscpRemarkBurstSize;
        }

        @Override
        public Long getDscpRemarkRate() {
            return this._dscpRemarkRate;
        }

        @Override
        public Short getPercLevel() {
            return this._percLevel;
        }

        public <E extends Augmentation<DscpRemark>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dscpRemarkBurstSize == null ? 0 : this._dscpRemarkBurstSize.hashCode());
            result = 31 * result + (this._dscpRemarkRate == null ? 0 : this._dscpRemarkRate.hashCode());
            result = 31 * result + (this._percLevel == null ? 0 : this._percLevel.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DscpRemarkImpl other = (DscpRemarkImpl)obj;
            if (this._dscpRemarkBurstSize == null ? other._dscpRemarkBurstSize != null : !this._dscpRemarkBurstSize.equals(other._dscpRemarkBurstSize)) {
                return false;
            }
            if (this._dscpRemarkRate == null ? other._dscpRemarkRate != null : !this._dscpRemarkRate.equals(other._dscpRemarkRate)) {
                return false;
            }
            if (this._percLevel == null ? other._percLevel != null : !this._percLevel.equals(other._percLevel)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DscpRemark [_dscpRemarkBurstSize=");
            builder.append(this._dscpRemarkBurstSize);
            builder.append(", _dscpRemarkRate=");
            builder.append(this._dscpRemarkRate);
            builder.append(", _percLevel=");
            builder.append(this._percLevel);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

