/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.band.type.band.type.Drop;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class DropBuilder {
    private Long _dropBurstSize;
    private Long _dropRate;
    private Map<Class<? extends Augmentation<Drop>>, Augmentation<Drop>> augmentation = new HashMap<Class<? extends Augmentation<Drop>>, Augmentation<Drop>>();

    public Long getDropBurstSize() {
        return this._dropBurstSize;
    }

    public Long getDropRate() {
        return this._dropRate;
    }

    public <E extends Augmentation<Drop>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DropBuilder setDropBurstSize(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dropBurstSize = value;
        return this;
    }

    public DropBuilder setDropRate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dropRate = value;
        return this;
    }

    public DropBuilder addAugmentation(Class<? extends Augmentation<Drop>> augmentationType, Augmentation<Drop> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Drop build() {
        return new DropImpl(this);
    }

    private static final class DropImpl
    implements Drop {
        private final Long _dropBurstSize;
        private final Long _dropRate;
        private Map<Class<? extends Augmentation<Drop>>, Augmentation<Drop>> augmentation = new HashMap<Class<? extends Augmentation<Drop>>, Augmentation<Drop>>();

        public Class<Drop> getImplementedInterface() {
            return Drop.class;
        }

        private DropImpl(DropBuilder builder) {
            this._dropBurstSize = builder.getDropBurstSize();
            this._dropRate = builder.getDropRate();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getDropBurstSize() {
            return this._dropBurstSize;
        }

        @Override
        public Long getDropRate() {
            return this._dropRate;
        }

        public <E extends Augmentation<Drop>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dropBurstSize == null ? 0 : this._dropBurstSize.hashCode());
            result = 31 * result + (this._dropRate == null ? 0 : this._dropRate.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DropImpl other = (DropImpl)obj;
            if (this._dropBurstSize == null ? other._dropBurstSize != null : !this._dropBurstSize.equals(other._dropBurstSize)) {
                return false;
            }
            if (this._dropRate == null ? other._dropRate != null : !this._dropRate.equals(other._dropRate)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Drop [_dropBurstSize=");
            builder.append(this._dropBurstSize);
            builder.append(", _dropRate=");
            builder.append(this._dropRate);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

