/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918;

import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.util.ArrayList;

public class BandId {
    private final Long _value;

    @ConstructorProperties(value={"value"})
    public BandId(Long _value) {
        if (_value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)_value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", _value, rangeConstraints));
            }
        }
        this._value = _value;
    }

    public BandId(BandId source) {
        this._value = source._value;
    }

    public static BandId getDefaultInstance(String defaultValue) {
        return new BandId(new Long(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BandId other = (BandId)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BandId [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

