/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.request;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.request.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.request.GroupStatsKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class GroupStatsBuilder {
    private GroupId _groupId;
    private GroupStatsKey _key;
    private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();

    public GroupId getGroupId() {
        return this._groupId;
    }

    public GroupStatsKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupStatsBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupStatsBuilder setKey(GroupStatsKey value) {
        this._key = value;
        return this;
    }

    public GroupStatsBuilder addAugmentation(Class<? extends Augmentation<GroupStats>> augmentationType, Augmentation<GroupStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupStats build() {
        return new GroupStatsImpl(this);
    }

    private static final class GroupStatsImpl
    implements GroupStats {
        private final GroupId _groupId;
        private final GroupStatsKey _key;
        private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();

        public Class<GroupStats> getImplementedInterface() {
            return GroupStats.class;
        }

        private GroupStatsImpl(GroupStatsBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new GroupStatsKey(builder.getGroupId());
                this._groupId = builder.getGroupId();
            } else {
                this._key = builder.getKey();
                this._groupId = this._key.getGroupId();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public GroupStatsKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupStatsImpl other = (GroupStatsImpl)obj;
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupStats [_groupId=");
            builder.append(this._groupId);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

