/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.Duration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStatsKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupStatsBuilder {
    private GroupStatsKey _key;
    private Buckets _buckets;
    private Counter64 _byteCount;
    private Duration _duration;
    private GroupId _groupId;
    private Counter64 _packetCount;
    private Counter32 _refCount;
    private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();

    public GroupStatsBuilder() {
    }

    public GroupStatsBuilder(GroupStatistics arg) {
        this._buckets = arg.getBuckets();
        this._byteCount = arg.getByteCount();
        this._duration = arg.getDuration();
        this._groupId = arg.getGroupId();
        this._packetCount = arg.getPacketCount();
        this._refCount = arg.getRefCount();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GroupStatistics) {
            this._buckets = ((GroupStatistics)arg).getBuckets();
            this._byteCount = ((GroupStatistics)arg).getByteCount();
            this._duration = ((GroupStatistics)arg).getDuration();
            this._groupId = ((GroupStatistics)arg).getGroupId();
            this._packetCount = ((GroupStatistics)arg).getPacketCount();
            this._refCount = ((GroupStatistics)arg).getRefCount();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupStatistics] \nbut was: " + arg);
        }
    }

    public GroupStatsKey getKey() {
        return this._key;
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public Counter64 getByteCount() {
        return this._byteCount;
    }

    public Duration getDuration() {
        return this._duration;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public Counter64 getPacketCount() {
        return this._packetCount;
    }

    public Counter32 getRefCount() {
        return this._refCount;
    }

    public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupStatsBuilder setKey(GroupStatsKey value) {
        this._key = value;
        return this;
    }

    public GroupStatsBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public GroupStatsBuilder setByteCount(Counter64 value) {
        this._byteCount = value;
        return this;
    }

    public GroupStatsBuilder setDuration(Duration value) {
        this._duration = value;
        return this;
    }

    public GroupStatsBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupStatsBuilder setPacketCount(Counter64 value) {
        this._packetCount = value;
        return this;
    }

    public GroupStatsBuilder setRefCount(Counter32 value) {
        this._refCount = value;
        return this;
    }

    public GroupStatsBuilder addAugmentation(Class<? extends Augmentation<GroupStats>> augmentationType, Augmentation<GroupStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupStats build() {
        return new GroupStatsImpl(this);
    }

    private static final class GroupStatsImpl
    implements GroupStats {
        private final GroupStatsKey _key;
        private final Buckets _buckets;
        private final Counter64 _byteCount;
        private final Duration _duration;
        private final GroupId _groupId;
        private final Counter64 _packetCount;
        private final Counter32 _refCount;
        private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();

        public Class<GroupStats> getImplementedInterface() {
            return GroupStats.class;
        }

        private GroupStatsImpl(GroupStatsBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new GroupStatsKey(builder.getGroupId());
                this._groupId = builder.getGroupId();
            } else {
                this._key = builder.getKey();
                this._groupId = this._key.getGroupId();
            }
            this._buckets = builder.getBuckets();
            this._byteCount = builder.getByteCount();
            this._duration = builder.getDuration();
            this._packetCount = builder.getPacketCount();
            this._refCount = builder.getRefCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public GroupStatsKey getKey() {
            return this._key;
        }

        @Override
        public Buckets getBuckets() {
            return this._buckets;
        }

        @Override
        public Counter64 getByteCount() {
            return this._byteCount;
        }

        @Override
        public Duration getDuration() {
            return this._duration;
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public Counter64 getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Counter32 getRefCount() {
            return this._refCount;
        }

        public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._buckets == null ? 0 : this._buckets.hashCode());
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._duration == null ? 0 : this._duration.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this._refCount == null ? 0 : this._refCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupStatsImpl other = (GroupStatsImpl)obj;
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._buckets == null ? other._buckets != null : !this._buckets.equals(other._buckets)) {
                return false;
            }
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals((Object)other._byteCount)) {
                return false;
            }
            if (this._duration == null ? other._duration != null : !this._duration.equals(other._duration)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals((Object)other._packetCount)) {
                return false;
            }
            if (this._refCount == null ? other._refCount != null : !this._refCount.equals((Object)other._refCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupStats [_key=");
            builder.append(this._key);
            builder.append(", _buckets=");
            builder.append(this._buckets);
            builder.append(", _byteCount=");
            builder.append(this._byteCount);
            builder.append(", _duration=");
            builder.append(this._duration);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", _refCount=");
            builder.append(this._refCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

