/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.buckets;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.BucketId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.buckets.BucketCounter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.buckets.BucketCounterKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BucketCounterBuilder {
    private BucketId _bucketId;
    private Counter64 _byteCount;
    private Counter64 _packetCount;
    private BucketCounterKey _key;
    private Map<Class<? extends Augmentation<BucketCounter>>, Augmentation<BucketCounter>> augmentation = new HashMap<Class<? extends Augmentation<BucketCounter>>, Augmentation<BucketCounter>>();

    public BucketId getBucketId() {
        return this._bucketId;
    }

    public Counter64 getByteCount() {
        return this._byteCount;
    }

    public Counter64 getPacketCount() {
        return this._packetCount;
    }

    public BucketCounterKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BucketCounter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BucketCounterBuilder setBucketId(BucketId value) {
        this._bucketId = value;
        return this;
    }

    public BucketCounterBuilder setByteCount(Counter64 value) {
        this._byteCount = value;
        return this;
    }

    public BucketCounterBuilder setPacketCount(Counter64 value) {
        this._packetCount = value;
        return this;
    }

    public BucketCounterBuilder setKey(BucketCounterKey value) {
        this._key = value;
        return this;
    }

    public BucketCounterBuilder addAugmentation(Class<? extends Augmentation<BucketCounter>> augmentationType, Augmentation<BucketCounter> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BucketCounter build() {
        return new BucketCounterImpl(this);
    }

    private static final class BucketCounterImpl
    implements BucketCounter {
        private final BucketId _bucketId;
        private final Counter64 _byteCount;
        private final Counter64 _packetCount;
        private final BucketCounterKey _key;
        private Map<Class<? extends Augmentation<BucketCounter>>, Augmentation<BucketCounter>> augmentation = new HashMap<Class<? extends Augmentation<BucketCounter>>, Augmentation<BucketCounter>>();

        public Class<BucketCounter> getImplementedInterface() {
            return BucketCounter.class;
        }

        private BucketCounterImpl(BucketCounterBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new BucketCounterKey(builder.getBucketId());
                this._bucketId = builder.getBucketId();
            } else {
                this._key = builder.getKey();
                this._bucketId = this._key.getBucketId();
            }
            this._byteCount = builder.getByteCount();
            this._packetCount = builder.getPacketCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BucketId getBucketId() {
            return this._bucketId;
        }

        @Override
        public Counter64 getByteCount() {
            return this._byteCount;
        }

        @Override
        public Counter64 getPacketCount() {
            return this._packetCount;
        }

        @Override
        public BucketCounterKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BucketCounter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bucketId == null ? 0 : this._bucketId.hashCode());
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketCounterImpl other = (BucketCounterImpl)obj;
            if (this._bucketId == null ? other._bucketId != null : !this._bucketId.equals(other._bucketId)) {
                return false;
            }
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals((Object)other._byteCount)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals((Object)other._packetCount)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BucketCounter [_bucketId=");
            builder.append(this._bucketId);
            builder.append(", _byteCount=");
            builder.append(this._byteCount);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

