/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.ActionList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.BucketId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.Bucket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.BucketKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BucketBuilder {
    private BucketId _bucketId;
    private Long _watchGroup;
    private Long _watchPort;
    private Integer _weight;
    private BucketKey _key;
    private List<Action> _action;
    private Map<Class<? extends Augmentation<Bucket>>, Augmentation<Bucket>> augmentation = new HashMap<Class<? extends Augmentation<Bucket>>, Augmentation<Bucket>>();

    public BucketBuilder() {
    }

    public BucketBuilder(ActionList arg) {
        this._action = arg.getAction();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ActionList) {
            this._action = ((ActionList)arg).getAction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.ActionList] \nbut was: " + arg);
        }
    }

    public BucketId getBucketId() {
        return this._bucketId;
    }

    public Long getWatchGroup() {
        return this._watchGroup;
    }

    public Long getWatchPort() {
        return this._watchPort;
    }

    public Integer getWeight() {
        return this._weight;
    }

    public BucketKey getKey() {
        return this._key;
    }

    public List<Action> getAction() {
        return this._action;
    }

    public <E extends Augmentation<Bucket>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BucketBuilder setBucketId(BucketId value) {
        this._bucketId = value;
        return this;
    }

    public BucketBuilder setWatchGroup(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._watchGroup = value;
        return this;
    }

    public BucketBuilder setWatchPort(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._watchPort = value;
        return this;
    }

    public BucketBuilder setWeight(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._weight = value;
        return this;
    }

    public BucketBuilder setKey(BucketKey value) {
        this._key = value;
        return this;
    }

    public BucketBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    public BucketBuilder addAugmentation(Class<? extends Augmentation<Bucket>> augmentationType, Augmentation<Bucket> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Bucket build() {
        return new BucketImpl(this);
    }

    private static final class BucketImpl
    implements Bucket {
        private final BucketId _bucketId;
        private final Long _watchGroup;
        private final Long _watchPort;
        private final Integer _weight;
        private final BucketKey _key;
        private final List<Action> _action;
        private Map<Class<? extends Augmentation<Bucket>>, Augmentation<Bucket>> augmentation = new HashMap<Class<? extends Augmentation<Bucket>>, Augmentation<Bucket>>();

        public Class<Bucket> getImplementedInterface() {
            return Bucket.class;
        }

        private BucketImpl(BucketBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new BucketKey(builder.getBucketId());
                this._bucketId = builder.getBucketId();
            } else {
                this._key = builder.getKey();
                this._bucketId = this._key.getBucketId();
            }
            this._watchGroup = builder.getWatchGroup();
            this._watchPort = builder.getWatchPort();
            this._weight = builder.getWeight();
            this._action = builder.getAction();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BucketId getBucketId() {
            return this._bucketId;
        }

        @Override
        public Long getWatchGroup() {
            return this._watchGroup;
        }

        @Override
        public Long getWatchPort() {
            return this._watchPort;
        }

        @Override
        public Integer getWeight() {
            return this._weight;
        }

        @Override
        public BucketKey getKey() {
            return this._key;
        }

        @Override
        public List<Action> getAction() {
            return this._action;
        }

        public <E extends Augmentation<Bucket>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bucketId == null ? 0 : this._bucketId.hashCode());
            result = 31 * result + (this._watchGroup == null ? 0 : this._watchGroup.hashCode());
            result = 31 * result + (this._watchPort == null ? 0 : this._watchPort.hashCode());
            result = 31 * result + (this._weight == null ? 0 : this._weight.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._action == null ? 0 : this._action.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketImpl other = (BucketImpl)obj;
            if (this._bucketId == null ? other._bucketId != null : !this._bucketId.equals(other._bucketId)) {
                return false;
            }
            if (this._watchGroup == null ? other._watchGroup != null : !this._watchGroup.equals(other._watchGroup)) {
                return false;
            }
            if (this._watchPort == null ? other._watchPort != null : !this._watchPort.equals(other._watchPort)) {
                return false;
            }
            if (this._weight == null ? other._weight != null : !this._weight.equals(other._weight)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._action == null ? other._action != null : !this._action.equals(other._action)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Bucket [_bucketId=");
            builder.append(this._bucketId);
            builder.append(", _watchGroup=");
            builder.append(this._watchGroup);
            builder.append(", _watchPort=");
            builder.append(this._watchPort);
            builder.append(", _weight=");
            builder.append(this._weight);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _action=");
            builder.append(this._action);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

