/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.buckets.Bucket;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BucketsBuilder {
    private List<Bucket> _bucket;
    private Map<Class<? extends Augmentation<Buckets>>, Augmentation<Buckets>> augmentation = new HashMap<Class<? extends Augmentation<Buckets>>, Augmentation<Buckets>>();

    public List<Bucket> getBucket() {
        return this._bucket;
    }

    public <E extends Augmentation<Buckets>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BucketsBuilder setBucket(List<Bucket> value) {
        this._bucket = value;
        return this;
    }

    public BucketsBuilder addAugmentation(Class<? extends Augmentation<Buckets>> augmentationType, Augmentation<Buckets> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Buckets build() {
        return new BucketsImpl(this);
    }

    private static final class BucketsImpl
    implements Buckets {
        private final List<Bucket> _bucket;
        private Map<Class<? extends Augmentation<Buckets>>, Augmentation<Buckets>> augmentation = new HashMap<Class<? extends Augmentation<Buckets>>, Augmentation<Buckets>>();

        public Class<Buckets> getImplementedInterface() {
            return Buckets.class;
        }

        private BucketsImpl(BucketsBuilder builder) {
            this._bucket = builder.getBucket();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Bucket> getBucket() {
            return this._bucket;
        }

        public <E extends Augmentation<Buckets>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bucket == null ? 0 : this._bucket.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketsImpl other = (BucketsImpl)obj;
            if (this._bucket == null ? other._bucket != null : !this._bucket.equals(other._bucket)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Buckets [_bucket=");
            builder.append(this._bucket);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

