/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.write.metadata._case;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.write.metadata._case.WriteMetadata;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class WriteMetadataBuilder {
    private BigInteger _metadata;
    private BigInteger _metadataMask;
    private Map<Class<? extends Augmentation<WriteMetadata>>, Augmentation<WriteMetadata>> augmentation = new HashMap<Class<? extends Augmentation<WriteMetadata>>, Augmentation<WriteMetadata>>();

    public BigInteger getMetadata() {
        return this._metadata;
    }

    public BigInteger getMetadataMask() {
        return this._metadataMask;
    }

    public <E extends Augmentation<WriteMetadata>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public WriteMetadataBuilder setMetadata(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._metadata = value;
        return this;
    }

    public WriteMetadataBuilder setMetadataMask(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._metadataMask = value;
        return this;
    }

    public WriteMetadataBuilder addAugmentation(Class<? extends Augmentation<WriteMetadata>> augmentationType, Augmentation<WriteMetadata> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public WriteMetadata build() {
        return new WriteMetadataImpl(this);
    }

    private static final class WriteMetadataImpl
    implements WriteMetadata {
        private final BigInteger _metadata;
        private final BigInteger _metadataMask;
        private Map<Class<? extends Augmentation<WriteMetadata>>, Augmentation<WriteMetadata>> augmentation = new HashMap<Class<? extends Augmentation<WriteMetadata>>, Augmentation<WriteMetadata>>();

        public Class<WriteMetadata> getImplementedInterface() {
            return WriteMetadata.class;
        }

        private WriteMetadataImpl(WriteMetadataBuilder builder) {
            this._metadata = builder.getMetadata();
            this._metadataMask = builder.getMetadataMask();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getMetadata() {
            return this._metadata;
        }

        @Override
        public BigInteger getMetadataMask() {
            return this._metadataMask;
        }

        public <E extends Augmentation<WriteMetadata>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._metadata == null ? 0 : this._metadata.hashCode());
            result = 31 * result + (this._metadataMask == null ? 0 : this._metadataMask.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriteMetadataImpl other = (WriteMetadataImpl)obj;
            if (this._metadata == null ? other._metadata != null : !this._metadata.equals(other._metadata)) {
                return false;
            }
            if (this._metadataMask == null ? other._metadataMask != null : !this._metadataMask.equals(other._metadataMask)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("WriteMetadata [_metadata=");
            builder.append(this._metadata);
            builder.append(", _metadataMask=");
            builder.append(this._metadataMask);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

