/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.meter._case;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.meter._case.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MeterBuilder {
    private MeterId _meterId;
    private Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>();

    public MeterId getMeterId() {
        return this._meterId;
    }

    public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterBuilder addAugmentation(Class<? extends Augmentation<Meter>> augmentationType, Augmentation<Meter> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Meter build() {
        return new MeterImpl(this);
    }

    private static final class MeterImpl
    implements Meter {
        private final MeterId _meterId;
        private Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>();

        public Class<Meter> getImplementedInterface() {
            return Meter.class;
        }

        private MeterImpl(MeterBuilder builder) {
            this._meterId = builder.getMeterId();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterImpl other = (MeterImpl)obj;
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals(other._meterId)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Meter [_meterId=");
            builder.append(this._meterId);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

