/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.MeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.instruction.meter._case.Meter;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MeterCaseBuilder {
    private Meter _meter;
    private Map<Class<? extends Augmentation<MeterCase>>, Augmentation<MeterCase>> augmentation = new HashMap<Class<? extends Augmentation<MeterCase>>, Augmentation<MeterCase>>();

    public Meter getMeter() {
        return this._meter;
    }

    public <E extends Augmentation<MeterCase>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterCaseBuilder setMeter(Meter value) {
        this._meter = value;
        return this;
    }

    public MeterCaseBuilder addAugmentation(Class<? extends Augmentation<MeterCase>> augmentationType, Augmentation<MeterCase> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterCase build() {
        return new MeterCaseImpl(this);
    }

    private static final class MeterCaseImpl
    implements MeterCase {
        private final Meter _meter;
        private Map<Class<? extends Augmentation<MeterCase>>, Augmentation<MeterCase>> augmentation = new HashMap<Class<? extends Augmentation<MeterCase>>, Augmentation<MeterCase>>();

        public Class<MeterCase> getImplementedInterface() {
            return MeterCase.class;
        }

        private MeterCaseImpl(MeterCaseBuilder builder) {
            this._meter = builder.getMeter();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Meter getMeter() {
            return this._meter;
        }

        public <E extends Augmentation<MeterCase>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._meter == null ? 0 : this._meter.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterCaseImpl other = (MeterCaseImpl)obj;
            if (this._meter == null ? other._meter != null : !this._meter.equals(other._meter)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterCase [_meter=");
            builder.append(this._meter);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

